/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ignite3.cache.CacheStoreFactory;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryRequest;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryScanResultWithSchema;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.failure.handlers.NoOpFailureHandler;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.marshaller.ReflectionMarshallersProvider;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.ColumnsExtractor;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite3.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.table.CachingKeyValueBinaryView;
import org.apache.ignite3.internal.table.CachingKeyValueView;
import org.apache.ignite3.internal.table.CloseableKeyValueView;
import org.apache.ignite3.internal.table.CloseableRecordView;
import org.apache.ignite3.internal.table.CloseableRecordViewInternal;
import org.apache.ignite3.internal.table.IndexWrapper;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.KeyValueBinaryViewImpl;
import org.apache.ignite3.internal.table.KeyValueViewImpl;
import org.apache.ignite3.internal.table.RecordBinaryViewImpl;
import org.apache.ignite3.internal.table.RecordViewImpl;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.IndexLocker;
import org.apache.ignite3.internal.table.distributed.PartitionSet;
import org.apache.ignite3.internal.table.distributed.TableIndexStoragesSupplier;
import org.apache.ignite3.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite3.internal.table.distributed.TableStatsStalenessConfiguration;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite3.internal.table.metrics.TableMetricSource;
import org.apache.ignite3.internal.table.partition.HashPartitionManagerImpl;
import org.apache.ignite3.internal.tx.LockManager;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.NearCacheOptions;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.TableViewOptions;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.PartitionManager;
import org.gridgain.internal.table.nearcache.NearCache;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKeyValueView;
import org.gridgain.internal.table.nearcache.NearCacheRecordView;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TableImpl
implements TableViewInternal {
    private final InternalTable tbl;
    private final LockManager lockManager;
    private final SchemaVersions schemaVersions;
    private final IgniteSql sql;
    private final FailureProcessor failureProcessor;
    private volatile SchemaRegistry schemaReg;
    private final Map<Integer, IndexWrapper> indexWrapperById = new ConcurrentHashMap<Integer, IndexWrapper>();
    private final MarshallersProvider marshallers;
    private final int pkId;
    private volatile TableStatsStalenessConfiguration configuration;

    public TableImpl(InternalTable tbl, LockManager lockManager, SchemaVersions schemaVersions, MarshallersProvider marshallers, IgniteSql sql, FailureProcessor failureProcessor, int pkId, TableStatsStalenessConfiguration tableStatsStalenessConfiguration) {
        this.tbl = tbl;
        this.lockManager = lockManager;
        this.schemaVersions = schemaVersions;
        this.marshallers = marshallers;
        this.sql = sql;
        this.failureProcessor = failureProcessor;
        this.pkId = pkId;
        this.configuration = tableStatsStalenessConfiguration;
    }

    @TestOnly
    public TableImpl(InternalTable tbl, SchemaRegistry schemaReg, LockManager lockManager, SchemaVersions schemaVersions, IgniteSql sql, int pkId) {
        this(tbl, lockManager, schemaVersions, new ReflectionMarshallersProvider(), sql, new FailureManager(new NoOpFailureHandler()), pkId, new TableStatsStalenessConfiguration(0.2, 500L));
        this.schemaReg = schemaReg;
    }

    @Override
    public int tableId() {
        return this.tbl.tableId();
    }

    @Override
    public int zoneId() {
        return this.tbl.zoneId();
    }

    @Override
    public int pkId() {
        return this.pkId;
    }

    @Override
    public InternalTable internalTable() {
        return this.tbl;
    }

    @Override
    public PartitionManager partitionManager() {
        return new HashPartitionManagerImpl(this.tbl, this.schemaReg, this.marshallers);
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.tbl.name();
    }

    public void name(String newName) {
        this.tbl.name(newName);
    }

    @Override
    public SchemaRegistry schemaView() {
        return this.schemaReg;
    }

    @Override
    public void schemaView(SchemaRegistry schemaReg) {
        Objects.requireNonNull(schemaReg, () -> "Schema registry must not be null [tableName=" + this.name() + "]");
        this.schemaReg = schemaReg;
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return this.recordView(recMapper, TableViewOptions.DEFAULT);
    }

    @Override
    public RecordView<Tuple> recordView() {
        return this.recordView(TableViewOptions.DEFAULT);
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper, TableViewOptions tableViewOptions) {
        Objects.requireNonNull(tableViewOptions);
        RecordView<R> recordView = new RecordViewImpl<R>(this.tbl, this.schemaReg, this.schemaVersions, this.sql, this.marshallers, recMapper);
        NearCacheOptions nearCacheOptions = tableViewOptions.nearCacheOptions();
        if (nearCacheOptions != null) {
            NearCache nearCache = new NearCache(recordView, nearCacheOptions);
            recordView = new NearCacheRecordView(recordView, nearCache);
        }
        return new CloseableRecordView<R>(recordView);
    }

    @Override
    public RecordView<Tuple> recordView(TableViewOptions tableViewOptions) {
        RecordView<Tuple> recordView;
        Objects.requireNonNull(tableViewOptions);
        RecordBinaryViewImpl internalView = recordView = new RecordBinaryViewImpl(this.tbl, this.schemaReg, this.schemaVersions, this.sql, this.marshallers);
        NearCacheOptions nearCacheOptions = tableViewOptions.nearCacheOptions();
        if (nearCacheOptions != null) {
            NearCache<Tuple, Tuple, BinaryRowEx> nearCache = new NearCache<Tuple, Tuple, BinaryRowEx>((NearCacheEntriesProvider<Tuple, Tuple, BinaryRowEx>)((Object)recordView), nearCacheOptions);
            recordView = new NearCacheRecordView<Tuple, BinaryRowEx>(recordView, nearCache);
        }
        return new CloseableRecordViewInternal<Tuple>(recordView, internalView);
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return this.keyValueView(keyMapper, valMapper, TableViewOptions.DEFAULT);
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView() {
        return this.keyValueView(TableViewOptions.DEFAULT);
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper, TableViewOptions tableViewOptions) {
        Objects.requireNonNull(tableViewOptions);
        KeyValueView<K, V> kvView = new KeyValueViewImpl<K, V>(this.tbl, this.schemaReg, this.schemaVersions, this.sql, this.marshallers, keyMapper, valMapper);
        NearCacheOptions nearCacheOptions = tableViewOptions.nearCacheOptions();
        if (nearCacheOptions != null) {
            NearCache nearCache = new NearCache(kvView, nearCacheOptions);
            kvView = new NearCacheKeyValueView(kvView, nearCache);
        }
        return new CloseableKeyValueView<K, V>(kvView);
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions tableViewOptions) {
        Objects.requireNonNull(tableViewOptions);
        KeyValueView<Tuple, Tuple> kvView = new KeyValueBinaryViewImpl(this.tbl, this.schemaReg, this.schemaVersions, this.sql, this.marshallers);
        NearCacheOptions nearCacheOptions = tableViewOptions.nearCacheOptions();
        if (nearCacheOptions != null) {
            NearCache<Tuple, Tuple, BinaryRowEx> nearCache = new NearCache<Tuple, Tuple, BinaryRowEx>((NearCacheEntriesProvider<Tuple, Tuple, BinaryRowEx>)((Object)kvView), nearCacheOptions);
            kvView = new NearCacheKeyValueView<Tuple, Tuple, BinaryRowEx>(kvView, nearCache);
        }
        return new CloseableKeyValueView<Tuple, Tuple>(kvView);
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(CacheStoreFactory fac, Mapper<K> keyMapper, Mapper<V> valMapper) {
        Objects.requireNonNull(fac);
        return new CachingKeyValueView<K, V>(this.tbl.transactions(), this.keyValueView(keyMapper, valMapper), fac.create(keyMapper.targetType(), valMapper.targetType()));
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView(CacheStoreFactory fac) {
        Objects.requireNonNull(fac);
        return new CachingKeyValueBinaryView(this.tbl.transactions(), this.keyValueView(), fac.create(Tuple.class, Tuple.class));
    }

    @Override
    public int partitionId(Tuple key) {
        Objects.requireNonNull(key);
        Row keyRow = new TupleMarshallerImpl(this.schemaReg.lastKnownSchema()).marshalKey(key);
        return this.tbl.partitionId(keyRow);
    }

    @Override
    public <K> int partitionId(K key, Mapper<K> keyMapper) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(keyMapper);
        KvMarshallerImpl<K, K> marshaller = new KvMarshallerImpl<K, K>(this.schemaReg.lastKnownSchema(), this.marshallers, keyMapper, keyMapper);
        Row keyRow = marshaller.marshal(key);
        return this.tbl.partitionId(keyRow);
    }

    @Override
    public TableIndexStoragesSupplier indexStorageAdapters(int partitionId) {
        return () -> {
            ArrayList<IndexWrapper> factories = new ArrayList<IndexWrapper>(this.indexWrapperById.values());
            HashMap<Integer, TableSchemaAwareIndexStorage> adapters = new HashMap<Integer, TableSchemaAwareIndexStorage>();
            for (IndexWrapper factory : factories) {
                TableSchemaAwareIndexStorage storage = factory.getStorage(partitionId);
                if (storage == null) continue;
                adapters.put(storage.id(), storage);
            }
            return adapters;
        };
    }

    @Override
    public Supplier<Map<Integer, IndexLocker>> indexesLockers(int partId) {
        return () -> {
            ArrayList<IndexWrapper> factories = new ArrayList<IndexWrapper>(this.indexWrapperById.values());
            HashMap<Integer, IndexLocker> lockers = new HashMap<Integer, IndexLocker>(factories.size());
            for (IndexWrapper factory : factories) {
                IndexLocker locker = factory.getLocker(partId);
                lockers.put(locker.id(), locker);
            }
            return lockers;
        };
    }

    @Override
    public void registerHashIndex(StorageHashIndexDescriptor indexDescriptor, boolean unique, ColumnsExtractor searchRowResolver, PartitionSet partitions) {
        int indexId = indexDescriptor.id();
        partitions.stream().forEach(partitionId -> this.tbl.storage().createHashIndex(partitionId, indexDescriptor));
        this.indexWrapperById.put(indexId, new IndexWrapper.HashIndexWrapper(this.tbl, this.lockManager, indexId, searchRowResolver, unique));
    }

    @Override
    public void registerSortedIndex(StorageSortedIndexDescriptor indexDescriptor, boolean unique, ColumnsExtractor searchRowResolver, PartitionSet partitions) {
        int indexId = indexDescriptor.id();
        partitions.stream().forEach(partitionId -> this.tbl.storage().createSortedIndex(partitionId, indexDescriptor));
        this.indexWrapperById.put(indexId, new IndexWrapper.SortedIndexWrapper(this.tbl, this.lockManager, indexId, searchRowResolver, unique));
    }

    @Override
    public void unregisterIndex(int indexId) {
        this.indexWrapperById.remove(indexId);
        this.tbl.storage().destroyIndex(indexId).whenComplete((res, e) -> {
            if (e != null) {
                this.failureProcessor.process(new FailureContext((Throwable)e, String.format("Unable to destroy index %s", indexId)));
            }
        });
    }

    @Override
    public TableMetricSource metrics() {
        return this.tbl.metrics();
    }

    @Override
    public CompletableFuture<ContinuousQueryScanResultWithSchema<BinaryRow, SchemaDescriptor>> sendContinuousQueryRequest(ContinuousQueryRequest req) {
        return this.tbl.sendContinuousQueryRequest(req);
    }

    @Override
    public boolean cache() {
        return this.internalTable().cache();
    }

    @Override
    public void updateStalenessConfiguration(@Nullable Double staleRowsFraction, @Nullable Long minStaleRowsCount) {
        TableStatsStalenessConfiguration configuration = this.configuration;
        this.configuration = configuration.update(staleRowsFraction, minStaleRowsCount);
    }

    @Override
    public TableStatsStalenessConfiguration stalenessConfiguration() {
        return this.configuration;
    }
}

