/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.pagememory.DataRegion;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.StorageDestroyedException;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.engine.MvTableStorage;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.pagememory.AbstractPageMemoryStorageEngine;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.util.MvPartitionStorages;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryTableStorage<T extends AbstractPageMemoryMvPartitionStorage>
implements MvTableStorage {
    final MvPartitionStorages<T> mvPartitionStorages;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    private final StorageTableDescriptor tableDescriptor;
    private final StorageIndexDescriptorSupplier indexDescriptorSupplier;

    AbstractPageMemoryTableStorage(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) {
        this.tableDescriptor = tableDescriptor;
        this.indexDescriptorSupplier = indexDescriptorSupplier;
        this.mvPartitionStorages = new MvPartitionStorages(tableDescriptor.getId(), tableDescriptor.getPartitions());
    }

    public StorageIndexDescriptorSupplier getIndexDescriptorSupplier() {
        return this.indexDescriptorSupplier;
    }

    public abstract DataRegion<?> dataRegion();

    public abstract AbstractPageMemoryStorageEngine engine();

    @Override
    public CompletableFuture<Void> destroy() {
        if (!StorageUtils.transitionToDestroyedState(this.state)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.beforeCloseOrDestroy();
        return ((CompletableFuture)this.mvPartitionStorages.getAllForCloseOrDestroy().thenCompose(storages -> CompletableFuture.allOf((CompletableFuture[])storages.stream().map(this::destroyMvPartitionStorage).toArray(CompletableFuture[]::new)))).whenComplete((unused, throwable) -> {
            if (throwable == null) {
                this.finishDestruction();
            }
        });
    }

    protected abstract void finishDestruction();

    public abstract T createMvPartitionStorage(int var1) throws StorageException;

    abstract CompletableFuture<Void> destroyMvPartitionStorage(AbstractPageMemoryMvPartitionStorage var1);

    @Override
    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.create(partitionId, partId -> {
            T partition = this.createMvPartitionStorage(partitionId);
            ((AbstractPageMemoryMvPartitionStorage)partition).start();
            return partition;
        }));
    }

    @Override
    @Nullable
    public MvPartitionStorage getMvPartition(int partitionId) {
        return this.busy(() -> (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId));
    }

    @Override
    public CompletableFuture<Void> destroyPartition(int partitionId) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletableFuture<Void> completableFuture = this.mvPartitionStorages.destroy(partitionId, this::destroyMvPartitionStorage);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void createSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        this.busy(() -> {
            AbstractPageMemoryMvPartitionStorage partitionStorage = (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId);
            if (partitionStorage != null) {
                partitionStorage.createSortedIndex(indexDescriptor);
            }
        });
    }

    @Override
    public void createHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        this.busy(() -> {
            AbstractPageMemoryMvPartitionStorage partitionStorage = (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId);
            if (partitionStorage != null) {
                partitionStorage.createHashIndex(indexDescriptor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> destroyIndex(int indexId) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            List<T> storages = this.mvPartitionStorages.getAll();
            CompletableFuture[] destroyFutures = new CompletableFuture[storages.size()];
            for (int i = 0; i < storages.size(); ++i) {
                AbstractPageMemoryMvPartitionStorage storage = (AbstractPageMemoryMvPartitionStorage)storages.get(i);
                try {
                    destroyFutures[i] = ((CompletableFuture)storage.runConsistently(locker -> storage.destroyIndex(indexId)).handle((res, ex) -> {
                        if (ex != null && AbstractPageMemoryTableStorage.isIgnorableIndexDestructionException(ex)) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        return CompletableFutures.completedOrFailedFuture(res, ex);
                    })).thenCompose(Function.identity());
                    continue;
                }
                catch (StorageDestroyedException e) {
                    destroyFutures[i] = CompletableFutures.nullCompletedFuture();
                }
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(destroyFutures);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static boolean isIgnorableIndexDestructionException(Throwable ex) {
        Throwable cause = ExceptionUtils.unwrapCause(ex);
        return cause instanceof StorageDestroyedException || cause instanceof GradualTaskExecutor.GradualTaskCancellationException;
    }

    @Override
    public void close() throws StorageException {
        if (!StorageUtils.transitionToClosedState(this.state, this::createStorageInfo)) {
            return;
        }
        this.busyLock.block();
        this.beforeCloseOrDestroy();
        try {
            CompletableFuture<List<T>> allForCloseOrDestroy = this.mvPartitionStorages.getAllForCloseOrDestroy();
            IgniteUtils.closeAllManually(allForCloseOrDestroy.get(10L, TimeUnit.SECONDS).stream());
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop PageMemory table storage: " + this.getTableId(), (Throwable)e);
        }
    }

    private String createStorageInfo() {
        return IgniteStringFormatter.format("tableId={}", this.getTableId());
    }

    protected <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void busy(Runnable action) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        try {
            action.run();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.startRebalance(partitionId, mvPartitionStorage -> {
            mvPartitionStorage.startRebalance();
            return this.clearStorageAndUpdateDataStructures((AbstractPageMemoryMvPartitionStorage)mvPartitionStorage).thenAccept(unused -> mvPartitionStorage.runConsistently(locker -> {
                mvPartitionStorage.lastAppliedOnRebalance(-1L, -1L);
                return null;
            }));
        }));
    }

    @Override
    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.abortRebalance(partitionId, mvPartitionStorage -> this.clearStorageAndUpdateDataStructures((AbstractPageMemoryMvPartitionStorage)mvPartitionStorage).thenAccept(unused -> {
            mvPartitionStorage.runConsistently(locker -> {
                mvPartitionStorage.lastAppliedOnRebalance(0L, 0L);
                return null;
            });
            mvPartitionStorage.completeRebalance();
        })));
    }

    @Override
    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        return this.busy(() -> this.mvPartitionStorages.finishRebalance(partitionId, mvPartitionStorage -> {
            mvPartitionStorage.runConsistently(locker -> {
                mvPartitionStorage.lastAppliedOnRebalance(partitionMeta.lastAppliedIndex(), partitionMeta.lastAppliedTerm());
                mvPartitionStorage.committedGroupConfigurationOnRebalance(partitionMeta.groupConfig());
                LeaseInfo leaseInfo = partitionMeta.leaseInfo();
                if (leaseInfo != null) {
                    mvPartitionStorage.updateLeaseOnRebalance(leaseInfo);
                }
                return null;
            });
            mvPartitionStorage.completeRebalance();
            return CompletableFutures.nullCompletedFuture();
        }));
    }

    @Override
    public CompletableFuture<Void> clearPartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.clear(partitionId, mvPartitionStorage -> {
            try {
                mvPartitionStorage.startCleanup();
                return this.clearStorageAndUpdateDataStructures((AbstractPageMemoryMvPartitionStorage)mvPartitionStorage).whenComplete((unused, throwable) -> mvPartitionStorage.finishCleanup());
            }
            catch (StorageException e) {
                mvPartitionStorage.finishCleanup();
                throw e;
            }
            catch (Throwable t) {
                mvPartitionStorage.finishCleanup();
                throw new StorageException("Failed to cleanup storage: [{}]", t, mvPartitionStorage.createStorageInfo());
            }
        }));
    }

    abstract CompletableFuture<Void> clearStorageAndUpdateDataStructures(AbstractPageMemoryMvPartitionStorage var1);

    public int getTableId() {
        return this.tableDescriptor.getId();
    }

    @Override
    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return this.busy(() -> {
            AbstractPageMemoryMvPartitionStorage partitionStorage = (AbstractPageMemoryMvPartitionStorage)this.mvPartitionStorages.get(partitionId);
            if (partitionStorage == null) {
                throw new StorageException(StorageUtils.createMissingMvPartitionErrorMessage(partitionId));
            }
            return partitionStorage.getIndex(indexId);
        });
    }

    @Override
    public StorageTableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    protected void beforeCloseOrDestroy() {
    }
}

