/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.sequence;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

public class SqlDropSequence
extends SqlDrop {
    private final SqlIdentifier name;

    public SqlDropSequence(SqlParserPos pos, boolean existFlag, SqlIdentifier name) {
        super((SqlOperator)new Operator(existFlag), pos, existFlag);
        this.name = name;
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifExists() {
        return this.getOperator().existFlag();
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("SEQUENCE");
        if (this.ifExists()) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    protected static class Operator
    extends IgniteDdlOperator {
        public Operator(boolean existFlag) {
            super("DROP SEQUENCE", SqlKind.DROP_SEQUENCE, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDropSequence(pos, this.existFlag(), (SqlIdentifier)operands[0]);
        }
    }
}

