/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.sequence;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

public class SqlAlterSequence
extends SqlDdl {
    private final SqlIdentifier name;
    @Nullable
    private final Long increment;
    @Nullable
    private final Long minvalue;
    @Nullable
    private final Long maxvalue;
    @Nullable
    private final Long start;
    @Nullable
    private final Long cache;

    public SqlAlterSequence(SqlParserPos pos, boolean existFlag, SqlIdentifier name, @Nullable Long increment, @Nullable Long minvalue, @Nullable Long maxvalue, @Nullable Long start, @Nullable Long cache) {
        super((SqlOperator)new Operator(existFlag, increment, minvalue, maxvalue, start, cache), pos);
        this.name = name;
        this.increment = increment;
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.start = start;
        this.cache = cache;
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER SEQUENCE");
        if (this.ifExists()) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.increment != null) {
            writer.keyword("INCREMENT BY");
            writer.literal(String.valueOf(this.increment));
        }
        if (this.minvalue != null) {
            writer.keyword("MINVALUE");
            writer.literal(String.valueOf(this.minvalue));
        }
        if (this.maxvalue != null) {
            writer.keyword("MAXVALUE");
            writer.literal(String.valueOf(this.maxvalue));
        }
        if (this.start != null) {
            writer.keyword("START");
            writer.literal(String.valueOf(this.start));
        }
        if (this.cache != null) {
            writer.keyword("CACHE");
            writer.literal(String.valueOf(this.cache));
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    @Nullable
    public Long increment() {
        return this.increment;
    }

    @Nullable
    public Long minvalue() {
        return this.minvalue;
    }

    @Nullable
    public Long maxvalue() {
        return this.maxvalue;
    }

    @Nullable
    public Long start() {
        return this.start;
    }

    @Nullable
    public Long cache() {
        return this.cache;
    }

    public boolean ifExists() {
        return this.getOperator().existFlag();
    }

    protected static class Operator
    extends IgniteDdlOperator {
        @Nullable
        private final Long increment;
        @Nullable
        private final Long minvalue;
        @Nullable
        private final Long maxvalue;
        @Nullable
        private final Long start;
        @Nullable
        private final Long cache;

        public Operator(boolean existFlag, @Nullable Long increment, @Nullable Long minvalue, @Nullable Long maxvalue, @Nullable Long start, @Nullable Long cache) {
            super("ALTER SEQUENCE", SqlKind.ALTER_SEQUENCE, existFlag);
            this.increment = increment;
            this.minvalue = minvalue;
            this.maxvalue = maxvalue;
            this.start = start;
            this.cache = cache;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlAlterSequence(pos, this.existFlag(), (SqlIdentifier)operands[0], this.increment, this.minvalue, this.maxvalue, this.start, this.cache);
        }
    }
}

