/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.rbac;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.apache.ignite3.internal.sql.engine.sql.SqlShow;
import org.jetbrains.annotations.Nullable;

public class GridgainSqlShowUser
extends SqlShow {
    private static final SqlSpecialOperator OPERATOR = new Operator();
    private final SqlIdentifier username;

    public GridgainSqlShowUser(SqlParserPos pos, SqlIdentifier username) {
        super(pos);
        this.username = Objects.requireNonNull(username, "user name");
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.username);
    }

    public SqlIdentifier username() {
        return this.username;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SHOW");
        writer.keyword("USER");
        this.username.unparse(writer, leftPrec, rightPrec);
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        public Operator() {
            super("SHOW USER", SqlKind.OTHER);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlShowUser(pos, (SqlIdentifier)operands[0]);
        }
    }
}

