/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlCreateTable
extends SqlCreate {
    private final SqlIdentifier name;
    @Nullable
    private final SqlIdentifier zone;
    @Nullable
    private final SqlNode storageProfile;
    @Nullable
    private final SqlIdentifier secondaryZone;
    @Nullable
    private final SqlNode secondaryStorageProfile;
    @Nullable
    private final SqlNodeList columnList;
    @Nullable
    private final SqlNodeList colocationColumns;
    @Nullable
    private final SqlIdentifier expireColumn;
    @Nullable
    private final SqlIdentifier archiveColumn;
    @Nullable
    private final SqlNodeList tableProperties;

    public IgniteSqlCreateTable(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, @Nullable SqlNodeList columnList, @Nullable SqlNodeList colocationColumns, @Nullable SqlIdentifier zone, @Nullable SqlNode storageProfile, @Nullable SqlIdentifier secondaryZone, @Nullable SqlNode secondaryStorageProfile, @Nullable SqlIdentifier expireColumn, @Nullable SqlIdentifier archiveColumn, @Nullable SqlNodeList tableProperties) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.columnList = columnList;
        this.colocationColumns = colocationColumns;
        this.zone = zone;
        this.storageProfile = storageProfile;
        this.secondaryZone = secondaryZone;
        this.secondaryStorageProfile = secondaryStorageProfile;
        this.expireColumn = expireColumn;
        this.archiveColumn = archiveColumn;
        this.tableProperties = tableProperties;
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList, (Object)this.colocationColumns, (Object)this.zone, (Object)this.storageProfile, (Object)this.secondaryZone, (Object)this.secondaryStorageProfile, (Object)this.expireColumn, (Object[])new SqlNode[]{this.archiveColumn, this.tableProperties});
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame;
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.colocationColumns != null) {
            writer.keyword("COLOCATE BY");
            frame = writer.startList("(", ")");
            this.colocationColumns.unparse(writer, 0, 0);
            writer.endList(frame);
        }
        if (this.zone != null) {
            writer.keyword("PRIMARY ZONE");
            this.zone.unparse(writer, leftPrec, rightPrec);
        }
        if (this.storageProfile != null) {
            writer.keyword("PRIMARY STORAGE PROFILE");
            this.storageProfile.unparse(writer, leftPrec, rightPrec);
        }
        if (this.secondaryZone != null) {
            writer.keyword("SECONDARY ZONE");
            this.secondaryZone.unparse(writer, leftPrec, rightPrec);
        }
        if (this.secondaryStorageProfile != null) {
            writer.keyword("SECONDARY STORAGE PROFILE");
            this.secondaryStorageProfile.unparse(writer, leftPrec, rightPrec);
        }
        if (this.expireColumn != null) {
            writer.keyword("EXPIRE AT");
            this.expireColumn.unparse(writer, leftPrec, rightPrec);
        }
        if (this.archiveColumn != null) {
            writer.keyword("ARCHIVE AT");
            this.archiveColumn.unparse(writer, leftPrec, rightPrec);
        }
        if (this.tableProperties != null) {
            writer.keyword("WITH");
            frame = writer.startList("(", ")");
            this.tableProperties.unparse(writer, 0, 0);
            writer.endList(frame);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public SqlNodeList columnList() {
        return this.columnList;
    }

    public SqlNodeList colocationColumns() {
        return this.colocationColumns;
    }

    @Nullable
    public SqlIdentifier zone() {
        return this.zone;
    }

    @Nullable
    public SqlNode storageProfile() {
        return this.storageProfile;
    }

    @Nullable
    public SqlIdentifier secondaryZone() {
        return this.secondaryZone;
    }

    @Nullable
    public SqlNode secondaryStorageProfile() {
        return this.secondaryStorageProfile;
    }

    @Nullable
    public SqlIdentifier expireColumn() {
        return this.expireColumn;
    }

    @Nullable
    public SqlIdentifier archiveColumn() {
        return this.archiveColumn;
    }

    @Nullable
    public SqlNodeList tableProperties() {
        return this.tableProperties;
    }

    public boolean ifNotExists() {
        Operator operator = (Operator)this.getOperator();
        return operator.existFlag();
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("CREATE TABLE", SqlKind.CREATE_TABLE, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlCreateTable(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlNodeList)operands[1], (SqlNodeList)operands[2], (SqlIdentifier)operands[3], operands[4], (SqlIdentifier)operands[5], operands[6], (SqlIdentifier)operands[7], (SqlIdentifier)operands[8], (SqlNodeList)operands[9]);
        }
    }
}

