/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlCreateCache
extends SqlCreate {
    private final SqlIdentifier name;
    @Nullable
    private final SqlIdentifier zone;
    @Nullable
    private final SqlNode storageProfile;
    @Nullable
    private final SqlIdentifier writeMode;
    @Nullable
    private final SqlNodeList columnList;
    @Nullable
    private final SqlNodeList colocationColumns;
    @Nullable
    private final SqlIdentifier expireColumn;

    public IgniteSqlCreateCache(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, @Nullable SqlNodeList columnList, @Nullable SqlNodeList colocationColumns, @Nullable SqlIdentifier zone, @Nullable SqlNode storageProfile, @Nullable SqlIdentifier writeMode, @Nullable SqlIdentifier expireColumn) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.columnList = columnList;
        this.colocationColumns = colocationColumns;
        this.zone = zone;
        this.storageProfile = storageProfile;
        this.writeMode = writeMode;
        this.expireColumn = expireColumn;
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList, (Object)this.colocationColumns, (Object)this.zone, (Object)this.storageProfile, (Object)this.writeMode, (Object)this.expireColumn);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame;
        writer.keyword("CREATE");
        writer.keyword("CACHE");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.colocationColumns != null) {
            writer.keyword("COLOCATE BY");
            frame = writer.startList("(", ")");
            this.colocationColumns.unparse(writer, 0, 0);
            writer.endList(frame);
        }
        if (this.zone != null) {
            writer.keyword("PRIMARY ZONE");
            this.zone.unparse(writer, leftPrec, rightPrec);
        }
        if (this.storageProfile != null) {
            writer.keyword("PRIMARY STORAGE PROFILE");
            this.storageProfile.unparse(writer, leftPrec, rightPrec);
        }
        if (this.writeMode != null) {
            writer.keyword("WRITE MODE");
            this.writeMode.unparse(writer, leftPrec, rightPrec);
        }
        if (this.expireColumn != null) {
            writer.keyword("EXPIRE AT");
            this.expireColumn.unparse(writer, leftPrec, rightPrec);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    @Nullable
    public SqlNodeList columnList() {
        return this.columnList;
    }

    public SqlNodeList colocationColumns() {
        return this.colocationColumns;
    }

    @Nullable
    public SqlIdentifier zone() {
        return this.zone;
    }

    @Nullable
    public SqlNode storageProfile() {
        return this.storageProfile;
    }

    @Nullable
    public SqlIdentifier writeMode() {
        return this.writeMode;
    }

    public SqlIdentifier expireColumn() {
        return this.expireColumn;
    }

    public boolean ifNotExists() {
        Operator operator = (Operator)this.getOperator();
        return operator.existFlag();
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("CREATE CACHE", SqlKind.CREATE_TABLE, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlCreateCache(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlNodeList)operands[1], (SqlNodeList)operands[2], (SqlIdentifier)operands[3], operands[4], (SqlIdentifier)operands[5], (SqlIdentifier)operands[6]);
        }
    }
}

