/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.util.Iterator;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.ExternalFileQueue;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@NotThreadSafe
class RowQueueImpl<RowT>
implements RowQueue<RowT> {
    private final RowHandler.RowFactory<RowT> rowFactory;
    private final ExternalFileQueue externalQueue;

    RowQueueImpl(DataDirectory workDir, FileIoFactory fileIoFactory, RowHandler.RowFactory<RowT> rowFactory, int initialCapacity) {
        this.rowFactory = rowFactory;
        this.externalQueue = new ExternalFileQueue(fileIoFactory, workDir, rowFactory.columnsCount(), initialCapacity == 0 ? 512 : initialCapacity);
    }

    @Override
    @Nullable
    public RowT peek() {
        return this.fromBinaryTuple(this.externalQueue.peek());
    }

    @Override
    @Nullable
    public RowT poll() {
        return this.fromBinaryTuple(this.externalQueue.poll());
    }

    @Override
    public RowT remove() {
        return this.fromBinaryTuple(this.externalQueue.remove());
    }

    @Override
    public void add(RowT element) {
        Objects.requireNonNull(element, " element");
        BinaryTuple newRow = this.toBinaryTuple(element);
        this.externalQueue.add(newRow);
    }

    @Override
    public int size() {
        return this.externalQueue.size();
    }

    @Override
    public void clear() {
        this.externalQueue.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.externalQueue.isEmpty();
    }

    @Override
    @TestOnly
    public Iterator<RowT> iterator() {
        return CollectionUtils.mapIterable(this.externalQueue, this::fromBinaryTuple, null).iterator();
    }

    @Override
    public void close() throws Exception {
        this.externalQueue.close();
    }

    private BinaryTuple toBinaryTuple(RowT element) {
        return this.rowFactory.handler().toBinaryTuple(element);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private RowT fromBinaryTuple(@Nullable BinaryTuple oldRow) {
        return oldRow == null ? null : (RowT)this.rowFactory.create(oldRow);
    }
}

