/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.util.Iterator;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.ExternalHashJoinTable;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.util.ProjectedTuple;
import org.apache.ignite3.internal.util.TransformingIterator;
import org.jetbrains.annotations.TestOnly;

class RowHashJoinIndexImpl<RowT>
implements RowHashJoinIndex<RowT, RowT> {
    private static final int INITIAL_CAPACITY = 128;
    private final ExternalHashJoinTable externalHashIndex;
    private final RowHandler.RowFactory<RowT> rowFactory;
    private final RowHandler<RowT> keyHandler;
    private final int[] keyFields;

    RowHashJoinIndexImpl(DataDirectory workDir, FileIoFactory fileIoFactory, RowHandler.RowFactory<RowT> rowFactory, int[] keyFields) {
        this.rowFactory = rowFactory;
        this.keyFields = keyFields;
        this.keyHandler = rowFactory.handler().factory(RowSchema.map(rowFactory.rowSchema(), keyFields)).handler();
        this.externalHashIndex = new ExternalHashJoinTable(workDir, fileIoFactory, 128, rowFactory.columnsCount(), keyFields);
    }

    @Override
    public boolean contains(RowT key) {
        return this.externalHashIndex.contains(this.keyHandler.toBinaryTuple(key));
    }

    @Override
    public Iterator<RowT> lookup(RowT key) {
        BinaryTuple keyTuple = this.keyHandler.toBinaryTuple(key);
        Iterator<BinaryTuple> iter = this.externalHashIndex.lookup(keyTuple);
        return new TransformingIterator<BinaryTuple, Object>(iter, this.rowFactory::create);
    }

    @Override
    public Iterator<RowT> untouchedIterator() {
        return new TransformingIterator<BinaryTuple, Object>(this.externalHashIndex.untouchedIterator(), this.rowFactory::create);
    }

    @Override
    public void add(RowT element) {
        RowHandler<RowT> handler = this.rowFactory.handler();
        BinaryTuple valueTuple = handler.toBinaryTuple(element);
        BinaryTuple keyTuple = RowHashJoinIndexImpl.extractKey(valueTuple, this.keyFields);
        this.externalHashIndex.put(keyTuple, valueTuple);
    }

    @Override
    public void addEntry(RowHashJoinIndex.IndexEntry<RowT> entry) {
        RowHandler<RowT> handler = this.rowFactory.handler();
        BinaryTuple valueTuple = handler.toBinaryTuple(entry.row());
        BinaryTuple keyTuple = RowHashJoinIndexImpl.extractKey(valueTuple, this.keyFields);
        this.externalHashIndex.put(keyTuple, valueTuple, entry.touched());
    }

    private static BinaryTuple extractKey(BinaryTuple row, int[] keyFields) {
        ProjectedTuple tuple = new ProjectedTuple(row, keyFields);
        return new BinaryTuple(keyFields.length, tuple.byteBuffer());
    }

    @Override
    public int size() {
        return this.externalHashIndex.size();
    }

    @Override
    public void clear() {
        this.externalHashIndex.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.externalHashIndex.size() == 0;
    }

    @Override
    @TestOnly
    public Iterator<RowT> iterator() {
        return new TransformingIterator<BinaryTuple, Object>(this.externalHashIndex.iterator(), this.rowFactory::create);
    }

    @Override
    public void close() throws Exception {
        this.externalHashIndex.close();
    }
}

