/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.api;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.sql.BatchedArguments;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSet;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.Statement;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class SecuredIgniteSql
implements IgniteSql,
Wrapper {
    private final IgniteSql delegate;
    private final SecurityContext securityContext;

    public SecuredIgniteSql(IgniteSql delegate, SecurityContext securityContext) {
        this.delegate = delegate;
        this.securityContext = securityContext;
    }

    @Override
    public Statement createStatement(String query) {
        return this.delegate.createStatement(query);
    }

    @Override
    public Statement.StatementBuilder statementBuilder() {
        return this.delegate.statementBuilder();
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.execute(transaction, cancellationToken, query, arguments));
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.execute(transaction, cancellationToken, statement, arguments));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.execute(transaction, mapper, cancellationToken, query, arguments));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.execute(transaction, mapper, cancellationToken, statement, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeAsync(transaction, cancellationToken, query, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeAsync(transaction, cancellationToken, statement, arguments));
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeAsync(transaction, mapper, cancellationToken, query, arguments));
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeAsync(transaction, mapper, cancellationToken, statement, arguments));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, String dmlQuery, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatch(transaction, dmlQuery, batch));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatch(transaction, cancellationToken, dmlQuery, batch));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, Statement dmlStatement, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatch(transaction, dmlStatement, batch));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatch(transaction, cancellationToken, dmlStatement, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatchAsync(transaction, query, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatchAsync(transaction, cancellationToken, query, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatchAsync(transaction, statement, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeBatchAsync(transaction, cancellationToken, statement, batch));
    }

    @Override
    public void executeScript(String query, Object ... arguments) {
        GridGainSecurity.with(this.securityContext, () -> this.delegate.executeScript(query, arguments)).run();
    }

    @Override
    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        GridGainSecurity.with(this.securityContext, () -> this.delegate.executeScript(cancellationToken, query, arguments)).run();
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeScriptAsync(query, arguments));
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeScriptAsync(cancellationToken, query, arguments));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        if (classToUnwrap.isAssignableFrom(QueryProcessor.class)) {
            return Wrappers.unwrap(this.delegate, classToUnwrap);
        }
        return classToUnwrap.cast(this);
    }
}

