/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.restart;

import org.apache.ignite3.Ignite;
import org.apache.ignite3.internal.restart.IgniteAttachmentLock;
import org.apache.ignite3.internal.restart.RefCache;
import org.apache.ignite3.internal.restart.RestartProofKeyValueView;
import org.apache.ignite3.internal.restart.RestartProofPartitionManager;
import org.apache.ignite3.internal.restart.RestartProofRecordView;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersionsImpl;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.Table;
import org.apache.ignite3.table.TableViewOptions;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.PartitionManager;

class RestartProofTable
implements Table,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;
    private final int tableId;
    private final RefCache<Table> tableCache;

    RestartProofTable(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, int tableId) {
        this.attachmentLock = attachmentLock;
        this.tableId = tableId;
        this.tableCache = new RefCache<Table>(initialIgnite, this::tableFromIgnite);
    }

    static int tableId(Table table) {
        return Wrappers.unwrap(table, TableViewInternal.class).tableId();
    }

    private Table tableFromIgnite(Ignite ignite) {
        Table underlyingTable = ignite.tables().tables().stream().filter(table -> RestartProofTable.tableId(table) == this.tableId).findAny().orElse(null);
        if (underlyingTable == null) {
            throw SchemaVersionsImpl.tableNotFoundException(this.tableId);
        }
        return underlyingTable;
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.attachmentLock.attached(ignite -> this.tableCache.actualFor((Ignite)ignite).qualifiedName());
    }

    @Override
    public PartitionManager partitionManager() {
        return this.attachmentLock.attached(ignite -> new RestartProofPartitionManager(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).partitionManager()));
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView(recMapper)));
    }

    @Override
    public RecordView<Tuple> recordView() {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView()));
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper, TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView(recMapper, tableViewOptions)));
    }

    @Override
    public RecordView<Tuple> recordView(TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofRecordView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).recordView(tableViewOptions)));
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView(keyMapper, valMapper)));
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView() {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView()));
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper, TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView(keyMapper, valMapper, tableViewOptions)));
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions tableViewOptions) {
        return this.attachmentLock.attached(ignite -> new RestartProofKeyValueView(this.attachmentLock, (Ignite)ignite, currentIgnite -> this.tableCache.actualFor((Ignite)currentIgnite).keyValueView(tableViewOptions)));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap(this.tableCache.actualFor((Ignite)ignite), classToUnwrap));
    }
}

