/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.snapshot;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.snapshot.CreateCommand;
import org.apache.ignite3.internal.rest.api.snapshot.DeleteCommand;
import org.apache.ignite3.internal.rest.api.snapshot.RestoreCommand;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotOperation;

@Controller(value="/management/v1/snapshot")
@Tag(name="snapshotManagement")
public interface SnapshotManagementApi {
    @Post(value="create")
    @Operation(operationId="create", summary="Create snapshot", description="Creates a new snapshot.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Snapshot has been started."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Tables were not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CompletableFuture<UUID> create(@Body CreateCommand var1);

    @Get(value="operations")
    @Operation(operationId="getOperations", summary="Get all snapshot operations", description="Returns all snapshot operations.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Operations retrieved."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CompletableFuture<List<SnapshotOperation>> getOperations();

    @Get(value="operations/{operationId}")
    @Operation(operationId="getOperationById", summary="Get operation by ID", description="Returns operation by its ID.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Operation retrieved."), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Snapshot operation was not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CompletableFuture<List<SnapshotOperation>> getOperation(@PathVariable UUID var1, @QueryValue boolean var2);

    @Post(value="restore")
    @Operation(operationId="restore", summary="Restore snapshot", description="Restores a snapshot.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Snapshot restoration has been started."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Snapshot meta file was not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CompletableFuture<UUID> restore(@Body RestoreCommand var1);

    @Post(value="delete")
    @Operation(operationId="delete", summary="Delete snapshot", description="Deletes a snapshot.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Snapshot deletion has been started."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Snapshot was not found.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CompletableFuture<UUID> delete(@Body DeleteCommand var1);
}

