/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.recovery.pitr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

@Schema(description="Tables recovery request.")
public class TablesRecoveryRequest {
    @Schema(description="List of fully-qualified names of the tables to recover. Without quotes, case-sensitive.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final List<String> tables;
    @Schema(description="Point-in-Time recovery timestamp.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final Instant timestamp;

    @JsonCreator
    public TablesRecoveryRequest(@JsonProperty(value="tables") List<String> tables, @JsonProperty(value="timestamp") Instant timestamp) {
        this.tables = Objects.requireNonNull(tables);
        this.timestamp = Objects.requireNonNull(timestamp);
    }

    @JsonGetter(value="tables")
    public List<String> tables() {
        return this.tables;
    }

    @JsonGetter(value="timestamp")
    public Instant timestamp() {
        return this.timestamp;
    }
}

