/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.raft.storage.segstore.GroupIndexMeta;
import org.apache.ignite3.internal.raft.storage.segstore.IndexFileMeta;
import org.apache.ignite3.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentFilePointer;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentInfo;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

class IndexFileManager {
    private static final IgniteLogger LOG = Loggers.forClass(IndexFileManager.class);
    static final int MAGIC_NUMBER = 1810933610;
    static final int FORMAT_VERSION = 1;
    private static final String INDEX_FILE_NAME_FORMAT = "index-%010d-%010d.bin";
    static final int COMMON_META_SIZE = 12;
    static final int GROUP_META_SIZE = 32;
    static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final Path indexFilesDir;
    private int curFileOrdinal = 0;
    private final Map<Long, GroupIndexMeta> groupIndexMetas = new ConcurrentHashMap<Long, GroupIndexMeta>();

    IndexFileManager(Path baseDir) throws IOException {
        this.indexFilesDir = baseDir.resolve("index");
        Files.createDirectories(this.indexFilesDir, new FileAttribute[0]);
    }

    Path indexFilesDir() {
        return this.indexFilesDir;
    }

    Path saveIndexMemtable(ReadModeIndexMemTable indexMemTable) throws IOException {
        String fileName = IndexFileManager.indexFileName(this.curFileOrdinal, 0);
        Path tmpFilePath = this.indexFilesDir.resolve(fileName + ".tmp");
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmpFilePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));){
            byte[] headerBytes = this.serializeHeaderAndFillMetadata(indexMemTable);
            os.write(headerBytes);
            Iterator<Map.Entry<Long, SegmentInfo>> it = indexMemTable.iterator();
            while (it.hasNext()) {
                os.write(IndexFileManager.payload(it.next().getValue()));
            }
        }
        ++this.curFileOrdinal;
        return IndexFileManager.syncAndRename(tmpFilePath, tmpFilePath.resolveSibling(fileName));
    }

    @Nullable
    SegmentFilePointer getSegmentFilePointer(long groupId, long logIndex) throws IOException {
        GroupIndexMeta groupIndexMeta = this.groupIndexMetas.get(groupId);
        if (groupIndexMeta == null) {
            return null;
        }
        IndexFileMeta indexFileMeta = groupIndexMeta.indexMeta(logIndex);
        if (indexFileMeta == null) {
            return null;
        }
        Path indexFile = this.indexFilesDir.resolve(IndexFileManager.indexFileName(indexFileMeta.indexFileOrdinal(), 0));
        long payloadArrayIndex = logIndex - indexFileMeta.firstLogIndexInclusive();
        assert (payloadArrayIndex >= 0L) : payloadArrayIndex;
        long payloadOffset = (long)indexFileMeta.indexFilePayloadOffset() + payloadArrayIndex * 4L;
        try (SeekableByteChannel channel = Files.newByteChannel(indexFile, StandardOpenOption.READ);){
            channel.position(payloadOffset);
            ByteBuffer segmentPayloadOffsetBuffer = ByteBuffer.allocate(4).order(BYTE_ORDER);
            while (segmentPayloadOffsetBuffer.hasRemaining()) {
                int bytesRead = channel.read(segmentPayloadOffsetBuffer);
                if (bytesRead != -1) continue;
                throw new EOFException("EOF reached while reading index file: " + indexFile);
            }
            int segmentPayloadOffset = segmentPayloadOffsetBuffer.getInt(0);
            SegmentFilePointer segmentFilePointer = new SegmentFilePointer(indexFileMeta.indexFileOrdinal(), segmentPayloadOffset);
            return segmentFilePointer;
        }
    }

    long firstLogIndexInclusive(long groupId) {
        GroupIndexMeta groupIndexMeta = this.groupIndexMetas.get(groupId);
        return groupIndexMeta == null ? -1L : groupIndexMeta.firstLogIndexInclusive();
    }

    long lastLogIndexExclusive(long groupId) {
        GroupIndexMeta groupIndexMeta = this.groupIndexMetas.get(groupId);
        return groupIndexMeta == null ? -1L : groupIndexMeta.lastLogIndexExclusive();
    }

    private byte[] serializeHeaderAndFillMetadata(ReadModeIndexMemTable indexMemTable) {
        int numGroups = indexMemTable.numGroups();
        int headerSize = IndexFileManager.headerSize(numGroups);
        ByteBuffer headerBuffer = ByteBuffer.allocate(headerSize).order(BYTE_ORDER).putInt(1810933610).putInt(1).putInt(numGroups);
        int payloadOffset = headerSize;
        Iterator<Map.Entry<Long, SegmentInfo>> it = indexMemTable.iterator();
        while (it.hasNext()) {
            Map.Entry<Long, SegmentInfo> entry = it.next();
            Long groupId = entry.getKey();
            SegmentInfo segmentInfo = entry.getValue();
            long firstLogIndexInclusive = segmentInfo.firstLogIndexInclusive();
            long lastLogIndexExclusive = segmentInfo.lastLogIndexExclusive();
            IndexFileMeta indexFileMeta = new IndexFileMeta(firstLogIndexInclusive, lastLogIndexExclusive, payloadOffset, this.curFileOrdinal);
            this.putIndexFileMeta(groupId, indexFileMeta);
            headerBuffer.putLong(groupId).putInt(0).putInt(payloadOffset).putLong(firstLogIndexInclusive).putLong(lastLogIndexExclusive);
            payloadOffset += IndexFileManager.payloadSize(segmentInfo);
        }
        return headerBuffer.array();
    }

    private void putIndexFileMeta(Long groupId, IndexFileMeta indexFileMeta) {
        GroupIndexMeta existingGroupIndexMeta = this.groupIndexMetas.get(groupId);
        if (existingGroupIndexMeta == null) {
            this.groupIndexMetas.put(groupId, new GroupIndexMeta(indexFileMeta));
        } else {
            existingGroupIndexMeta.addIndexMeta(indexFileMeta);
        }
    }

    private static Path syncAndRename(Path from, Path to) throws IOException {
        IgniteUtils.fsyncFile(from);
        return IgniteUtils.atomicMoveFile(from, to, LOG);
    }

    private static byte[] payload(SegmentInfo segmentInfo) {
        ByteBuffer payloadBuffer = ByteBuffer.allocate(IndexFileManager.payloadSize(segmentInfo)).order(BYTE_ORDER);
        segmentInfo.saveOffsetsTo(payloadBuffer);
        return payloadBuffer.array();
    }

    private static int headerSize(int numGroups) {
        return 12 + numGroups * 32;
    }

    private static int payloadSize(SegmentInfo segmentInfo) {
        return segmentInfo.size() * 4;
    }

    private static String indexFileName(int fileOrdinal, int generation) {
        return String.format(INDEX_FILE_NAME_FORMAT, fileOrdinal, generation);
    }
}

