/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStateMessageBuilder;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;

class LocalPartitionStateMessageDeserializer
implements MessageDeserializer<LocalPartitionStateMessage> {
    private final LocalPartitionStateMessageBuilder msg;

    LocalPartitionStateMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.localPartitionStateMessage();
    }

    @Override
    public Class<LocalPartitionStateMessage> klass() {
        return LocalPartitionStateMessage.class;
    }

    @Override
    public LocalPartitionStateMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.localPartitionStateMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("estimatedRows");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.estimatedRows(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("logIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.logIndex(tmp);
                reader.incrementState();
            }
            case 2: {
                TablePartitionIdMessage tmp = (TablePartitionIdMessage)reader.readMessage("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.partitionId(tmp);
                }
                reader.incrementState();
            }
            case 3: {
                LocalPartitionStateEnum tmp;
                int shiftedId = reader.readInt("state");
                if (!reader.isLastRead()) {
                    return false;
                }
                LocalPartitionStateEnum localPartitionStateEnum = tmp = shiftedId == 0 ? null : LocalPartitionStateEnum.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.state(tmp);
                }
                reader.incrementState();
            }
            case 4: {
                ZonePartitionIdMessage tmp = (ZonePartitionIdMessage)reader.readMessage("zonePartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.zonePartitionId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalPartitionStateMessage.class);
    }
}

