/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.ReplicaPrimacy;
import org.apache.ignite3.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ContinuousQueryScanRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.GetEstimatedSizeRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.schemacompat.SchemaCompatibilityValidator;
import org.apache.ignite3.internal.replicator.message.ReadOnlyDirectReplicaRequest;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.replicator.message.SchemaVersionAwareReplicaRequest;
import org.apache.ignite3.internal.replicator.message.SecondaryStorageRequest;
import org.apache.ignite3.internal.replicator.message.TableAware;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.apache.ignite3.internal.tx.message.TableWriteIntentSwitchReplicaRequest;
import org.jetbrains.annotations.Nullable;

public class TableAwareReplicaRequestPreProcessor {
    private final ClockService clockService;
    private final SchemaCompatibilityValidator schemaCompatValidator;
    private final SchemaSyncService schemaSyncService;
    private final NodeProperties nodeProperties;

    public TableAwareReplicaRequestPreProcessor(ClockService clockService, SchemaCompatibilityValidator schemaCompatValidator, SchemaSyncService schemaSyncService, NodeProperties nodeProperties) {
        this.clockService = clockService;
        this.schemaCompatValidator = schemaCompatValidator;
        this.schemaSyncService = schemaSyncService;
        this.nodeProperties = nodeProperties;
    }

    public CompletableFuture<Void> preProcessTableAwareRequest(ReplicaRequest request, ReplicaPrimacy replicaPrimacy, UUID senderId) {
        assert (request instanceof TableAware) : "Request should be TableAware [request=" + request.getClass().getSimpleName() + "]";
        HybridTimestamp opTs = this.getOperationTimestamp(request);
        if (this.nodeProperties.colocationEnabled()) assert (opTs != null) : "Table aware operation timestamp must not be null [request=" + request + "]";
        HybridTimestamp opTsIfDirectRo = request instanceof ReadOnlyDirectReplicaRequest ? opTs : null;
        @Nullable HybridTimestamp txTs = TableAwareReplicaRequestPreProcessor.getTxStartTimestamp(request);
        if (txTs == null) {
            txTs = opTsIfDirectRo;
        }
        assert (txTs == null || opTs.compareTo(txTs) >= 0) : "Tx started at " + txTs + ", but opTs precedes it: " + opTs + "; request " + request;
        assert (txTs != null ? opTs.compareTo(txTs) >= 0 : request instanceof GetEstimatedSizeRequest || request instanceof ScanCloseReplicaRequest || request instanceof BuildIndexReplicaRequest || request instanceof TableWriteIntentSwitchReplicaRequest || request instanceof ContinuousQueryScanRequest || TableAwareReplicaRequestPreProcessor.isSecondaryStorageRequest(request)) : "Invalid request timestamps [request=" + request + "]";
        int tableId = ((TableAware)((Object)request)).tableId();
        @Nullable HybridTimestamp finalTxTs = txTs;
        Runnable validateClo = () -> {
            boolean hasSchemaVersion;
            if (!(request instanceof ContinuousQueryScanRequest) && !TableAwareReplicaRequestPreProcessor.isSecondaryStorageRequest(request)) {
                this.schemaCompatValidator.failIfTableDoesNotExistAt(opTs, tableId);
            }
            if (hasSchemaVersion = request instanceof SchemaVersionAwareReplicaRequest) {
                SchemaVersionAwareReplicaRequest versionAwareRequest = (SchemaVersionAwareReplicaRequest)request;
                this.schemaCompatValidator.failIfRequestSchemaDiffersFromTxTs(finalTxTs, versionAwareRequest.schemaVersion(), tableId);
            }
        };
        return this.schemaSyncService.waitForMetadataCompleteness(opTs).thenRun(validateClo);
    }

    @Nullable
    public HybridTimestamp getOperationTimestamp(ReplicaRequest request) {
        HybridTimestamp opStartTs = this.nodeProperties.colocationEnabled() ? (request instanceof ReadOnlyReplicaRequest ? ((ReadOnlyReplicaRequest)request).readTimestamp() : this.clockService.current()) : (TableAwareReplicaRequestPreProcessor.isSecondaryStorageRequest(request) ? this.clockService.current() : (request instanceof ScanCloseReplicaRequest ? ((ScanCloseReplicaRequest)request).timestamp() : (request instanceof ReadWriteReplicaRequest ? this.clockService.current() : (request instanceof ReadOnlyReplicaRequest ? ((ReadOnlyReplicaRequest)request).readTimestamp() : (request instanceof ReadOnlyDirectReplicaRequest ? this.clockService.current() : null)))));
        return opStartTs;
    }

    private static boolean isSecondaryStorageRequest(ReplicaRequest request) {
        return request instanceof SecondaryStorageRequest;
    }

    @Nullable
    private static HybridTimestamp getTxStartTimestamp(ReplicaRequest request) {
        HybridTimestamp txStartTimestamp = request instanceof ReadWriteReplicaRequest ? TableAwareReplicaRequestPreProcessor.beginRwTxTs((ReadWriteReplicaRequest)request) : (request instanceof ReadOnlyReplicaRequest ? ((ReadOnlyReplicaRequest)request).readTimestamp() : null);
        return txStartTimestamp;
    }

    private static HybridTimestamp beginRwTxTs(ReadWriteReplicaRequest request) {
        return TransactionIds.beginTimestamp(request.transactionId());
    }
}

