/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.ru;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteUuid;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.direct.state.DirectMessageState;
import org.apache.ignite3.internal.network.direct.state.DirectMessageStateItem;
import org.apache.ignite3.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite3.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite3.internal.network.serialization.MessageTypeInfo;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class RollingUpgradeMessageReader
implements MessageReader {
    private final DirectMessageState<StateItem> state = new DirectMessageState<StateItem>(StateItem.class, () -> new StateItem(RollingUpgradeMessageReader.createStream(serializationRegistry, protoVer)));
    private boolean lastRead;

    public RollingUpgradeMessageReader(MessageSerializationRegistry serializationRegistry, byte protoVer) {
    }

    private static DirectByteBufferStream createStream(MessageSerializationRegistry serializationRegistry, byte protoVer) {
        switch (protoVer) {
            case 1: {
                return new DirectByteBufferStreamImplV1(serializationRegistry);
            }
        }
        throw new IllegalStateException("Invalid protocol version: " + protoVer);
    }

    @Override
    public void setBuffer(ByteBuffer buf) {
        this.state.item().stream.setBuffer(buf);
    }

    @Override
    public void setCurrentReadClass(Class<? extends NetworkMessage> msgCls) {
        this.state.item().readMsgCls = msgCls;
    }

    @Override
    public void setMessageTypeInfo(MessageTypeInfo messageTypeInfo) {
        this.state.item().messageTypeInfo = messageTypeInfo;
    }

    @Override
    public boolean beforeMessageRead() {
        StateItem item = this.state.item();
        if (item.fieldCnt == -1) {
            item.fieldCnt = item.stream.readByte();
            boolean finished = item.stream.lastFinished();
            if (!finished) {
                item.fieldCnt = (byte)-1;
            }
            return finished;
        }
        return true;
    }

    @Override
    public boolean afterMessageRead(Class<? extends NetworkMessage> msgCls) {
        return msgCls != this.state.item().readMsgCls || this.skipExtraFields();
    }

    @Override
    public byte readByte(String name) {
        StateItem item = this.state.item();
        if (!this.readFieldHeader((byte)1)) {
            return 0;
        }
        byte val = item.stream.readByte();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Byte readBoxedByte(String name) {
        StateItem item = this.state.item();
        if (!this.readFieldHeader((byte)9)) {
            return null;
        }
        Byte val = item.stream.readBoxedByte();
        this.onFieldRead();
        return val;
    }

    @Override
    public short readShort(String name) {
        if (!this.readFieldHeader((byte)2)) {
            return 0;
        }
        short val = this.state.item().stream.readShort();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Short readBoxedShort(String name) {
        if (!this.readFieldHeader((byte)10)) {
            return null;
        }
        Short val = this.state.item().stream.readBoxedShort();
        this.onFieldRead();
        return val;
    }

    @Override
    public int readInt(String name) {
        return this.readInt(name, 0);
    }

    @Override
    public int readInt(String name, int defaultValue) {
        if (!this.readFieldHeader((byte)3)) {
            return defaultValue;
        }
        int val = this.state.item().stream.readInt();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Integer readBoxedInt(String name) {
        if (!this.readFieldHeader((byte)11)) {
            return null;
        }
        Integer val = this.state.item().stream.readBoxedInt();
        this.onFieldRead();
        return val;
    }

    @Override
    public long readLong(String name) {
        if (!this.readFieldHeader((byte)4)) {
            return 0L;
        }
        long val = this.state.item().stream.readLong();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Long readBoxedLong(String name) {
        if (!this.readFieldHeader((byte)12)) {
            return null;
        }
        Long val = this.state.item().stream.readBoxedLong();
        this.onFieldRead();
        return val;
    }

    @Override
    public float readFloat(String name) {
        if (!this.readFieldHeader((byte)5)) {
            return 0.0f;
        }
        float val = this.state.item().stream.readFloat();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Float readBoxedFloat(String name) {
        if (!this.readFieldHeader((byte)13)) {
            return null;
        }
        Float val = this.state.item().stream.readBoxedFloat();
        this.onFieldRead();
        return val;
    }

    @Override
    public double readDouble(String name) {
        if (!this.readFieldHeader((byte)6)) {
            return 0.0;
        }
        double val = this.state.item().stream.readDouble();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Double readBoxedDouble(String name) {
        if (!this.readFieldHeader((byte)14)) {
            return null;
        }
        Double val = this.state.item().stream.readBoxedDouble();
        this.onFieldRead();
        return val;
    }

    @Override
    public char readChar(String name) {
        if (!this.readFieldHeader((byte)7)) {
            return '\u0000';
        }
        char val = this.state.item().stream.readChar();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Character readBoxedChar(String name) {
        if (!this.readFieldHeader((byte)15)) {
            return null;
        }
        Character val = this.state.item().stream.readBoxedChar();
        this.onFieldRead();
        return val;
    }

    @Override
    public boolean readBoolean(String name) {
        if (!this.readFieldHeader((byte)8)) {
            return false;
        }
        boolean val = this.state.item().stream.readBoolean();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public Boolean readBoxedBoolean(String name) {
        if (!this.readFieldHeader((byte)16)) {
            return null;
        }
        Boolean val = this.state.item().stream.readBoxedBoolean();
        this.onFieldRead();
        return val;
    }

    @Override
    public byte @Nullable [] readByteArray(String name) {
        if (!this.readFieldHeader((byte)17)) {
            return null;
        }
        byte[] val = this.state.item().stream.readByteArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public short[] readShortArray(String name) {
        if (!this.readFieldHeader((byte)18)) {
            return null;
        }
        short[] val = this.state.item().stream.readShortArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public int[] readIntArray(String name) {
        if (!this.readFieldHeader((byte)19)) {
            return null;
        }
        int[] val = this.state.item().stream.readIntArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public long[] readLongArray(String name) {
        if (!this.readFieldHeader((byte)20)) {
            return null;
        }
        long[] val = this.state.item().stream.readLongArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public float[] readFloatArray(String name) {
        if (!this.readFieldHeader((byte)21)) {
            return null;
        }
        float[] val = this.state.item().stream.readFloatArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public double[] readDoubleArray(String name) {
        if (!this.readFieldHeader((byte)22)) {
            return null;
        }
        double[] val = this.state.item().stream.readDoubleArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public char[] readCharArray(String name) {
        if (!this.readFieldHeader((byte)23)) {
            return null;
        }
        char[] val = this.state.item().stream.readCharArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public boolean[] readBooleanArray(String name) {
        if (!this.readFieldHeader((byte)24)) {
            return null;
        }
        boolean[] val = this.state.item().stream.readBooleanArray();
        this.onFieldRead();
        return val;
    }

    @Override
    public String readString(String name) {
        if (!this.readFieldHeader((byte)25)) {
            return null;
        }
        String val = this.state.item().stream.readString();
        this.onFieldRead();
        return val;
    }

    @Override
    public BitSet readBitSet(String name) {
        if (!this.readFieldHeader((byte)26)) {
            return null;
        }
        BitSet val = this.state.item().stream.readBitSet();
        this.onFieldRead();
        return val;
    }

    @Override
    public ByteBuffer readByteBuffer(String name) {
        if (!this.readFieldHeader((byte)27)) {
            return null;
        }
        ByteBuffer val = this.state.item().stream.readByteBuffer();
        this.onFieldRead();
        return val;
    }

    @Override
    public UUID readUuid(String name) {
        if (!this.readFieldHeader((byte)28)) {
            return null;
        }
        UUID val = this.state.item().stream.readUuid();
        this.onFieldRead();
        return val;
    }

    @Override
    public IgniteUuid readIgniteUuid(String name) {
        if (!this.readFieldHeader((byte)29)) {
            return null;
        }
        IgniteUuid val = this.state.item().stream.readIgniteUuid();
        this.onFieldRead();
        return val;
    }

    @Override
    @Nullable
    public HybridTimestamp readHybridTimestamp(String name) {
        return HybridTimestamp.nullableHybridTimestamp(this.readLong(name));
    }

    @Override
    public short readHeaderShort() {
        DirectByteBufferStream stream = this.state.item().stream;
        short val = stream.readShort();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public <T extends NetworkMessage> T readMessage(String name) {
        if (!this.readFieldHeader((byte)30)) {
            return null;
        }
        Object msg = this.state.item().stream.readMessage(this);
        this.onFieldRead();
        return msg;
    }

    @Override
    public <T> T[] readObjectArray(String name, MessageCollectionItemType itemType, Class<T> itemCls) {
        if (!this.readFieldHeader((byte)31)) {
            return null;
        }
        StateItem item = this.state.item();
        if (item.notVersionZero() && itemType != item.curItemType) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected array component type [name=" + name + ", expType=" + itemType + ", type=" + item.curItemType + "]");
        }
        T[] arr = item.stream.readObjectArray(itemType, itemCls, this);
        this.onFieldRead();
        return arr;
    }

    @Override
    public <C extends Collection<?>> C readCollection(String name, MessageCollectionItemType itemType) {
        if (!this.readFieldHeader((byte)32)) {
            return null;
        }
        StateItem item = this.state.item();
        if (item.notVersionZero() && itemType != item.curItemType) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected collection item type [name=" + name + ", expType=" + itemType + ", type=" + item.curItemType + "]");
        }
        Object col = item.stream.readCollection(itemType, this);
        this.onFieldRead();
        return col;
    }

    @Override
    public <C extends List<?>> C readList(String name, MessageCollectionItemType itemType) {
        if (!this.readFieldHeader((byte)34)) {
            return null;
        }
        StateItem item = this.state.item();
        if (item.notVersionZero() && itemType != item.curItemType) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected list item type [name=" + name + ", expType=" + itemType + ", type=" + item.curItemType + "]");
        }
        List col = (List)item.stream.readCollection(itemType, this);
        this.onFieldRead();
        return (C)col;
    }

    @Override
    public <C extends Set<?>> C readSet(String name, MessageCollectionItemType itemType) {
        if (!this.readFieldHeader((byte)35)) {
            return null;
        }
        StateItem item = this.state.item();
        if (item.notVersionZero() && itemType != item.curItemType) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected set item type [name=" + name + ", expType=" + itemType + ", type=" + item.curItemType + "]");
        }
        Object col = item.stream.readSet(itemType, this);
        this.onFieldRead();
        return col;
    }

    @Override
    public <M extends Map<?, ?>> M readMap(String name, MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked) {
        if (!this.readFieldHeader((byte)33)) {
            return null;
        }
        StateItem item = this.state.item();
        if (item.notVersionZero()) {
            if (keyType != item.curKeyType) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected map key type [name=" + name + ", expType=" + keyType + ", type=" + item.curKeyType + "]");
            }
            if (valType != item.curValType) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected map key type [name=" + name + ", expType=" + valType + ", type=" + item.curValType + "]");
            }
        }
        Object map = item.stream.readMap(keyType, valType, linked, this);
        this.onFieldRead();
        return map;
    }

    @Override
    public boolean isLastRead() {
        return this.lastRead;
    }

    @Override
    public int state() {
        return this.state.item().state;
    }

    @Override
    public void incrementState() {
        ++this.state.item().state;
    }

    @Override
    public void beforeInnerMessageRead() {
        this.state.forward();
    }

    @Override
    public void afterInnerMessageRead(boolean finished) {
        this.state.backward(finished);
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    private void onFieldRead() {
        StateItem item = this.state.item();
        this.lastRead = item.stream.lastFinished();
        if (this.lastRead) {
            item.readFieldCnt = (byte)(item.readFieldCnt + 1);
            item.typeRead = false;
            item.itemTypeRead = false;
            item.keyTypeRead = false;
            item.valTypeRead = false;
        }
    }

    private boolean readFieldHeader(byte expType) {
        StateItem item = this.state.item();
        if (item.readFieldCnt == item.fieldCnt) {
            this.lastRead = true;
            return false;
        }
        if (item.notVersionZero()) {
            if (!this.readFieldTypeInformation(item)) {
                return false;
            }
            if (expType != item.curType) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected field type [fieldIndex=" + item.readFieldCnt + ", expType=" + expType + ", type=" + item.curType + "]");
            }
        }
        return true;
    }

    private boolean readFieldTypeInformation(StateItem item) {
        if (!item.typeRead) {
            item.curType = item.stream.readByte();
            if (!item.stream.lastFinished()) {
                this.lastRead = false;
                return false;
            }
            item.typeRead = true;
        }
        if (RollingUpgradeMessageReader.isCollectionType(item.curType) && !item.itemTypeRead) {
            item.curItemType = MessageCollectionItemType.fromCode(item.stream.readByte());
            if (!item.stream.lastFinished()) {
                this.lastRead = false;
                return false;
            }
            item.itemTypeRead = true;
        }
        if (item.curType == 33) {
            if (!item.keyTypeRead) {
                item.curKeyType = MessageCollectionItemType.fromCode(item.stream.readByte());
                if (!item.stream.lastFinished()) {
                    this.lastRead = false;
                    return false;
                }
                item.keyTypeRead = true;
            }
            if (!item.valTypeRead) {
                item.curValType = MessageCollectionItemType.fromCode(item.stream.readByte());
                if (!item.stream.lastFinished()) {
                    this.lastRead = false;
                    return false;
                }
                item.valTypeRead = true;
            }
        }
        return true;
    }

    private static boolean isCollectionType(byte curType) {
        return curType == 31 || curType == 32 || curType == 34 || curType == 35;
    }

    private boolean skipExtraFields() {
        StateItem item = this.state.item();
        while (item.readFieldCnt < item.fieldCnt) {
            assert (item.notVersionZero());
            if (!this.readFieldTypeInformation(item)) {
                return false;
            }
            this.skipExtraField();
            this.onFieldRead();
            if (this.lastRead) continue;
            return false;
        }
        return true;
    }

    private void skipExtraField() {
        StateItem item = this.state.item();
        switch (item.curType) {
            case 1: {
                item.stream.readByte();
                break;
            }
            case 2: {
                item.stream.readShort();
                break;
            }
            case 3: {
                item.stream.readInt();
                break;
            }
            case 4: {
                item.stream.readLong();
                break;
            }
            case 5: {
                item.stream.readFloat();
                break;
            }
            case 6: {
                item.stream.readDouble();
                break;
            }
            case 7: {
                item.stream.readChar();
                break;
            }
            case 8: {
                item.stream.readBoolean();
                break;
            }
            case 9: {
                item.stream.readBoxedByte();
                break;
            }
            case 10: {
                item.stream.readBoxedShort();
                break;
            }
            case 11: {
                item.stream.readBoxedInt();
                break;
            }
            case 12: {
                item.stream.readBoxedLong();
                break;
            }
            case 13: {
                item.stream.readBoxedFloat();
                break;
            }
            case 14: {
                item.stream.readBoxedDouble();
                break;
            }
            case 15: {
                item.stream.readBoxedChar();
                break;
            }
            case 16: {
                item.stream.readBoxedBoolean();
                break;
            }
            case 17: {
                item.stream.readByteArray();
                break;
            }
            case 18: {
                item.stream.readShortArray();
                break;
            }
            case 19: {
                item.stream.readIntArray();
                break;
            }
            case 20: {
                item.stream.readLongArray();
                break;
            }
            case 21: {
                item.stream.readFloatArray();
                break;
            }
            case 22: {
                item.stream.readDoubleArray();
                break;
            }
            case 23: {
                item.stream.readCharArray();
                break;
            }
            case 24: {
                item.stream.readBooleanArray();
                break;
            }
            case 25: {
                item.stream.readString();
                break;
            }
            case 26: {
                item.stream.readBitSet();
                break;
            }
            case 27: {
                item.stream.readByteBuffer();
                break;
            }
            case 28: {
                item.stream.readUuid();
                break;
            }
            case 29: {
                item.stream.readIgniteUuid();
                break;
            }
            case 30: {
                item.stream.readMessage(this);
                break;
            }
            case 31: {
                item.stream.readObjectArray(item.curItemType, null, this);
                break;
            }
            case 32: {
                item.stream.readCollection(item.curItemType, this);
                break;
            }
            case 33: {
                item.stream.readMap(item.curKeyType, item.curValType, false, this);
                break;
            }
            case 34: {
                item.stream.readCollection(item.curItemType, this);
                break;
            }
            case 35: {
                item.stream.readSet(item.curItemType, this);
                break;
            }
            default: {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Invalid field type: " + item.curType);
            }
        }
    }

    public String toString() {
        return S.toString(RollingUpgradeMessageReader.class, this);
    }

    static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;
        private byte fieldCnt = (byte)-1;
        private byte readFieldCnt;
        private boolean typeRead;
        private boolean itemTypeRead;
        private boolean keyTypeRead;
        private boolean valTypeRead;
        private byte curType;
        @Nullable
        private MessageCollectionItemType curItemType;
        @Nullable
        private MessageCollectionItemType curKeyType;
        @Nullable
        private MessageCollectionItemType curValType;
        private Class<? extends NetworkMessage> readMsgCls;
        private MessageTypeInfo messageTypeInfo;

        StateItem(DirectByteBufferStream stream) {
            this.stream = stream;
        }

        @Override
        public void reset() {
            this.state = 0;
            this.fieldCnt = (byte)-1;
            this.readFieldCnt = 0;
            this.typeRead = false;
            this.itemTypeRead = false;
            this.keyTypeRead = false;
            this.valTypeRead = false;
            this.curType = 0;
            this.curItemType = null;
            this.curKeyType = null;
            this.curValType = null;
            this.readMsgCls = null;
        }

        boolean notVersionZero() {
            return this.readFieldCnt >= this.messageTypeInfo.version0FieldCount();
        }

        public String toString() {
            return S.toString(StateItem.class, this);
        }
    }
}

