/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.logger.IgniteLogger;

public enum HandshakeRejectionReason {
    STOPPING(System.Logger.Level.DEBUG),
    LOOP(System.Logger.Level.INFO),
    STALE_LAUNCH_ID(System.Logger.Level.WARNING),
    CLINCH(System.Logger.Level.DEBUG),
    CLUSTER_ID_MISMATCH(System.Logger.Level.WARNING),
    PRODUCT_MISMATCH(System.Logger.Level.WARNING),
    VERSION_MISMATCH(System.Logger.Level.WARNING);

    private final System.Logger.Level logLevel;

    private HandshakeRejectionReason(System.Logger.Level logLevel) {
        this.logLevel = logLevel;
    }

    public void print(boolean nodeStopping, IgniteLogger logger, String message, Object ... args) {
        if (nodeStopping) {
            logger.debug(message, args);
        } else {
            switch (this.logLevel) {
                case INFO: {
                    logger.info(message, args);
                    break;
                }
                case WARNING: {
                    logger.warn(message, args);
                    break;
                }
                case ERROR: {
                    logger.error(message, args);
                    break;
                }
                case DEBUG: {
                    logger.debug(message, args);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.logLevel.toString());
                }
            }
        }
    }
}

