/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessageImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class FieldDescriptorMessageSerializer
implements MessageSerializer<FieldDescriptorMessage> {
    public static final FieldDescriptorMessageSerializer INSTANCE = new FieldDescriptorMessageSerializer();

    private FieldDescriptorMessageSerializer() {
    }

    @Override
    public boolean writeMessage(FieldDescriptorMessage msg, MessageWriter writer) throws MessageMappingException {
        FieldDescriptorMessageImpl message = (FieldDescriptorMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.fieldDescriptorMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("className", message.className());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByte("flags", message.flags());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("name", message.name());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeInt("typeDescriptorId", message.typeDescriptorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

