/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.CommandId;
import org.apache.ignite3.internal.metastorage.command.InvokeCommand;
import org.apache.ignite3.internal.metastorage.command.InvokeCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class InvokeCommandDeserializer
implements MessageDeserializer<InvokeCommand> {
    private final InvokeCommandBuilder msg;

    InvokeCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.invokeCommand();
    }

    @Override
    public Class<InvokeCommand> klass() {
        return InvokeCommand.class;
    }

    @Override
    public InvokeCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.invokeCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (Condition)reader.readMessage("condition");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.condition((Condition)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readList("failure", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.failure((List<Operation>)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = (CommandId)reader.readMessage("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.id((CommandId)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readList("success", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.success((List<Operation>)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(InvokeCommand.class);
    }
}

