/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.command.GetAllCommand;
import org.apache.ignite3.internal.metastorage.command.GetAllCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.GetAllCommandSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;

public class GetAllCommandImpl
implements GetAllCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 30;
    @IgniteStringifier(name="keys.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> keys;
    @IgniteToStringInclude
    private final long revision;

    private GetAllCommandImpl(List<ByteBuffer> keys, long revision) {
        this.keys = keys;
        this.revision = revision;
    }

    @Override
    public List<ByteBuffer> keys() {
        return this.keys;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    public MessageSerializer serializer() {
        return GetAllCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(GetAllCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 30;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetAllCommandImpl otherMessage = (GetAllCommandImpl)other;
        return Objects.equals(this.keys, otherMessage.keys) && this.revision == otherMessage.revision;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.revision, this.keys);
        return result;
    }

    @Override
    public GetAllCommandImpl clone() {
        try {
            return (GetAllCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetAllCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetAllCommandBuilder {
        private List<ByteBuffer> keys;
        private long revision;

        private Builder() {
        }

        @Override
        public GetAllCommandBuilder keys(List<ByteBuffer> keys) {
            Objects.requireNonNull(keys, "keys is not marked @Nullable");
            this.keys = keys;
            return this;
        }

        @Override
        public GetAllCommandBuilder revision(long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public List<ByteBuffer> keys() {
            return this.keys;
        }

        @Override
        public long revision() {
            return this.revision;
        }

        @Override
        public GetAllCommand build() {
            return new GetAllCommandImpl(Objects.requireNonNull(this.keys, "keys is not marked @Nullable"), this.revision);
        }

        @Override
        public GetAllCommand buildDeserialized() {
            return new GetAllCommandImpl(this.keys, this.revision);
        }
    }
}

