/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.List;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.compute.JobExecutionOptions;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.ExecutionOptions;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class ExecutionContext {
    private final ExecutionOptions options;
    private final List<DeploymentUnit> units;
    private final String jobClassName;
    private final ComputeEventMetadataBuilder metadataBuilder;
    private final SecurityContext securityContext;
    private final ComputeJobDataHolder arg;

    public ExecutionContext(ExecutionOptions options, List<DeploymentUnit> units, String jobClassName, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable ComputeJobDataHolder arg) {
        this.options = options;
        this.units = units;
        this.jobClassName = jobClassName;
        this.metadataBuilder = metadataBuilder;
        this.securityContext = securityContext;
        this.arg = arg;
    }

    public ExecutionContext(JobExecutionOptions jobExecutionOptions, List<DeploymentUnit> units, String jobClassName, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable ComputeJobDataHolder arg) {
        this(ExecutionOptions.from(jobExecutionOptions), units, jobClassName, metadataBuilder, securityContext, arg);
    }

    public <T, R> ExecutionContext(JobDescriptor<T, R> descriptor, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable ComputeJobDataHolder arg) {
        this(descriptor.options(), descriptor.units(), descriptor.jobClassName(), metadataBuilder, securityContext, arg);
    }

    public ExecutionOptions options() {
        return this.options;
    }

    public List<DeploymentUnit> units() {
        return this.units;
    }

    public String jobClassName() {
        return this.jobClassName;
    }

    public ComputeEventMetadataBuilder metadataBuilder() {
        return this.metadataBuilder;
    }

    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Nullable
    public ComputeJobDataHolder arg() {
        return this.arg;
    }
}

