/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.raft;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.InvalidNodeConfigurationException;
import org.apache.ignite3.internal.cluster.management.MetaStorageInfo;
import org.apache.ignite3.internal.cluster.management.NodeAttributes;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.cluster.management.raft.IllegalInitArgumentException;
import org.apache.ignite3.internal.cluster.management.raft.JoinDeniedException;
import org.apache.ignite3.internal.cluster.management.raft.commands.ChangeMetaStorageInfoCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinReadyCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.JoinRequestCommand;
import org.apache.ignite3.internal.cluster.management.raft.commands.NodesLeaveCommand;
import org.apache.ignite3.internal.cluster.management.raft.responses.LogicalTopologyResponse;
import org.apache.ignite3.internal.cluster.management.raft.responses.ValidationErrorResponse;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class CmgRaftService
implements ManuallyCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterManagementGroupManager.class);
    private final CmgMessagesFactory msgFactory = new CmgMessagesFactory();
    private final RaftGroupService raftService;
    private final TopologyService topologyService;
    private final LogicalTopology logicalTopology;

    public CmgRaftService(RaftGroupService raftService, TopologyService topologyService, LogicalTopology logicalTopology) {
        this.raftService = raftService;
        this.topologyService = topologyService;
        this.logicalTopology = logicalTopology;
    }

    public CompletableFuture<Boolean> isCurrentNodeLeader() {
        Peer leader = this.raftService.leader();
        if (leader == null) {
            return this.raftService.refreshLeader().thenCompose(v -> this.isCurrentNodeLeader());
        }
        String nodeName = this.topologyService.localMember().name();
        return CompletableFuture.completedFuture(leader.consistentId().equals(nodeName));
    }

    public CompletableFuture<ClusterState> readClusterState() {
        return this.raftService.run(this.msgFactory.readStateCommand().build()).thenApply(ClusterState.class::cast);
    }

    public CompletableFuture<ClusterState> initClusterState(ClusterState clusterState) {
        ClusterNodeMessage localNodeMessage = this.nodeMessage(this.topologyService.localMember());
        return this.raftService.run(this.msgFactory.initCmgStateCommand().node(localNodeMessage).clusterState(clusterState).build()).thenApply(response -> {
            if (response instanceof ValidationErrorResponse) {
                throw new IllegalInitArgumentException("Init CMG request denied, reason: " + ((ValidationErrorResponse)response).reason());
            }
            if (response instanceof ClusterState) {
                return (ClusterState)response;
            }
            throw new IgniteInternalException("Unexpected response: " + response);
        });
    }

    public CompletableFuture<Void> startJoinCluster(ClusterTag clusterTag, NodeAttributes nodeAttributes) {
        ClusterNodeMessage localNodeMessage = this.nodeMessage(this.topologyService.localMember(), nodeAttributes);
        JoinRequestCommand command = this.msgFactory.joinRequestCommand().node(localNodeMessage).version(IgniteProductVersion.CURRENT_VERSION.toString()).clusterTag(clusterTag).build();
        return this.raftService.run(command, -1L).thenAccept(response -> {
            if (response instanceof ValidationErrorResponse) {
                ValidationErrorResponse validationErrorResponse = (ValidationErrorResponse)response;
                if (validationErrorResponse.isInvalidNodeConfig()) {
                    InvalidNodeConfigurationException invalidNodeConfigurationException = new InvalidNodeConfigurationException(validationErrorResponse.reason());
                    throw new JoinDeniedException("JoinRequest command failed", (Throwable)invalidNodeConfigurationException);
                }
                throw new JoinDeniedException(validationErrorResponse.reason());
            }
            if (response != null) {
                throw new IgniteInternalException("Unexpected response: " + response);
            }
            LOG.info("JoinRequest command executed successfully", new Object[0]);
        });
    }

    public CompletableFuture<Void> completeJoinCluster(NodeAttributes attributes) {
        LOG.info("Node is ready to join the logical topology", new Object[0]);
        ClusterNodeMessage localNodeMessage = this.nodeMessage(this.topologyService.localMember(), attributes);
        JoinReadyCommand joinReadyCommand = this.msgFactory.joinReadyCommand().node(localNodeMessage).build();
        return this.raftService.run(joinReadyCommand, -1L).thenAccept(response -> {
            if (response instanceof ValidationErrorResponse) {
                throw new JoinDeniedException("JoinReady request denied, reason: " + ((ValidationErrorResponse)response).reason());
            }
            if (response != null) {
                throw new IgniteInternalException("Unexpected response: " + response);
            }
            LOG.info("JoinReady command executed successfully", new Object[0]);
        });
    }

    public CompletableFuture<Void> removeFromCluster(Set<InternalClusterNode> nodes) {
        NodesLeaveCommand command = this.msgFactory.nodesLeaveCommand().nodes(nodes.stream().map(this::nodeMessage).collect(Collectors.toSet())).build();
        return this.raftService.run(command);
    }

    public CompletableFuture<LogicalTopologySnapshot> logicalTopology() {
        return ((CompletableFuture)this.raftService.run(this.msgFactory.readLogicalTopologyCommand().build()).thenApply(LogicalTopologyResponse.class::cast)).thenApply(LogicalTopologyResponse::logicalTopology);
    }

    public CompletableFuture<Set<InternalClusterNode>> validatedNodes() {
        return this.raftService.run(this.msgFactory.readValidatedNodesCommand().build());
    }

    public Set<String> nodeNames() {
        List<Peer> peers = this.raftService.peers();
        assert (peers != null);
        return peers.stream().map(Peer::consistentId).collect(Collectors.toSet());
    }

    public CompletableFuture<Set<String>> majority() {
        Peer leader = this.raftService.leader();
        if (leader == null) {
            return this.raftService.refreshLeader().thenCompose(v -> this.majority());
        }
        List<Peer> peers = this.raftService.peers();
        assert (peers != null);
        int peersCount = peers.size();
        String leaderId = leader.consistentId();
        Set result = peers.stream().map(Peer::consistentId).filter(consistentId -> !consistentId.equals(leaderId)).limit(peersCount / 2).collect(Collectors.toCollection(HashSet::new));
        result.add(leaderId);
        return CompletableFuture.completedFuture(result);
    }

    private ClusterNodeMessage nodeMessage(InternalClusterNode node, NodeAttributes attributes) {
        return this.msgFactory.clusterNodeMessage().id(node.id()).name(node.name()).host(node.address().host()).port(node.address().port()).userAttributes(attributes == null ? null : attributes.userAttributes()).systemAttributes(attributes == null ? null : attributes.systemAttributes()).storageProfiles(attributes == null ? null : attributes.storageProfiles()).build();
    }

    private ClusterNodeMessage nodeMessage(InternalClusterNode node) {
        return this.msgFactory.clusterNodeMessage().id(node.id()).name(node.name()).host(node.address().host()).port(node.address().port()).build();
    }

    public CompletableFuture<Set<String>> learners() {
        List<Peer> currentLearners = this.raftService.learners();
        if (currentLearners == null) {
            return this.raftService.refreshMembers(true).thenCompose(v -> this.learners());
        }
        return CompletableFuture.completedFuture(currentLearners.stream().map(Peer::consistentId).collect(Collectors.toSet()));
    }

    public CompletableFuture<Void> updateLearners(long term) {
        List<Peer> currentLearners = this.raftService.learners();
        if (currentLearners == null) {
            return this.raftService.refreshMembers(true).thenCompose(v -> this.updateLearners(term));
        }
        Set currentLearnerNames = currentLearners.stream().map(Peer::consistentId).collect(Collectors.toSet());
        Set<String> currentPeers = this.nodeNames();
        Set<String> newLearners = this.logicalTopology.getLogicalTopology().nodes().stream().map(InternalClusterNode::name).filter(name -> !currentPeers.contains(name)).collect(Collectors.toSet());
        if (currentLearnerNames.equals(newLearners)) {
            return CompletableFutures.nullCompletedFuture();
        }
        PeersAndLearners newConfiguration = PeersAndLearners.fromConsistentIds(currentPeers, newLearners);
        if (newLearners.isEmpty()) {
            return this.raftService.changePeersAndLearnersAsync(newConfiguration, term).thenRun(() -> this.raftService.updateConfiguration(newConfiguration));
        }
        return this.raftService.resetLearners(newConfiguration.learners());
    }

    public CompletableFuture<Void> changeMetastorageNodes(Set<String> newMetastorageNodes, @Nullable Long metastorageRepairingConfigIndex) {
        ChangeMetaStorageInfoCommand command = this.msgFactory.changeMetaStorageInfoCommand().metaStorageNodes(Set.copyOf(newMetastorageNodes)).metastorageRepairingConfigIndex(metastorageRepairingConfigIndex).build();
        return this.raftService.run(command);
    }

    public CompletableFuture<MetaStorageInfo> readMetaStorageInfo() {
        return this.raftService.run(this.msgFactory.readMetaStorageInfoCommand().build()).thenApply(MetaStorageInfo.class::cast);
    }

    public CompletableFuture<Void> rollingUpgradeVersion(String version) {
        return this.raftService.run(this.msgFactory.rollingUpgradeStartCommand().version(version).build());
    }

    public CompletableFuture<Void> rollingUpgradeCommit() {
        return this.raftService.run(this.msgFactory.rollingUpgradeCommit().build());
    }

    @Override
    public void close() {
        this.raftService.shutdown();
    }
}

