/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.SecondaryStorageAvailableEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateTable;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class SecondaryStorageAvailableEntry
extends UpdateTable
implements Fireable {
    private final int tableId;

    public SecondaryStorageAvailableEntry(int tableId) {
        this.tableId = tableId;
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SECONDARY_STORAGE_AVAILABLE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new SecondaryStorageAvailableEventParameters(causalityToken, catalogVersion, this.tableId);
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        return table.copyBuilder().latestSchemaVersion(SecondaryStorageAvailableEntry.newSchemaVersion(table)).secondaryStorageState(CatalogSecondaryStorageState.AVAILABLE);
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.SECONDARY_STORAGE_AVAILABLE.id();
    }
}

