/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.Arrays;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.DropTablePolicyEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class DropTablePolicyEntry
implements UpdateEntry,
Fireable {
    private final int policyId;

    public DropTablePolicyEntry(int policyId) {
        this.policyId = policyId;
    }

    public int policyId() {
        return this.policyId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_TABLE_POLICY.id();
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogTablePolicyDescriptor policy = catalog.policy(this.policyId);
        assert (policy != null);
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, policy.schemaId());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), schema.sequences(), (CatalogTablePolicyDescriptor[])Arrays.stream(schema.policies()).filter(t -> t.id() != this.policyId).toArray(CatalogTablePolicyDescriptor[]::new), schema.maps(), timestamp), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString(this);
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_POLICY_DROP;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropTablePolicyEventParameters(causalityToken, catalogVersion, this.policyId);
    }
}

