/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyPredicate;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataInput;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataOutput;

public class CatalogTablePolicyDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.6")
    static class TablePolicyDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogTablePolicyDescriptor> {
        TablePolicyDescriptorSerializerV2() {
        }

        @Override
        public CatalogTablePolicyDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long timestamp = input.readLong();
            int schemaId = input.readVarIntAsInt();
            int tableId = input.readVarIntAsInt();
            Set roleNames = input.readObjectCollection(IgniteUnsafeDataInput::readUTF, size -> new HashSet(IgniteUtils.capacity(size)));
            CatalogTablePolicyPredicate predicate = TablePolicyDescriptorSerializerV2.readPredicate(input);
            HybridTimestamp hybridTs = timestamp == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp(timestamp);
            return new CatalogTablePolicyDescriptor(id, name, hybridTs, schemaId, tableId, roleNames, predicate);
        }

        @Override
        public void writeTo(CatalogTablePolicyDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeLong(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.schemaId());
            output.writeVarInt(descriptor.tableId());
            output.writeObjectCollection(IgniteUnsafeDataOutput::writeUTF, descriptor.roles());
            TablePolicyDescriptorSerializerV2.writePredicate(descriptor.predicate(), output);
        }

        private static CatalogTablePolicyPredicate readPredicate(CatalogObjectDataInput input) throws IOException {
            byte predicateTypeId = input.readByte();
            CatalogTablePolicyPredicate.TablePolicyPredicateType predicateType = CatalogTablePolicyPredicate.TablePolicyPredicateType.getById(predicateTypeId);
            if (predicateType == CatalogTablePolicyPredicate.TablePolicyPredicateType.ALWAYS_TRUE) {
                return new CatalogTablePolicyPredicate.AlwaysTruePolicyPredicate();
            }
            if (predicateType == CatalogTablePolicyPredicate.TablePolicyPredicateType.CURRENT_USER) {
                String columnName = input.readUTF();
                return new CatalogTablePolicyPredicate.CurrentUserPolicyPredicate(columnName);
            }
            throw new IllegalStateException("Unsupported table policy predicate type [type=" + predicateType + "]");
        }

        private static void writePredicate(CatalogTablePolicyPredicate predicate, CatalogObjectDataOutput output) throws IOException {
            output.writeByte(predicate.type().id());
            if (predicate.type() == CatalogTablePolicyPredicate.TablePolicyPredicateType.ALWAYS_TRUE) {
                return;
            }
            if (predicate.type() == CatalogTablePolicyPredicate.TablePolicyPredicateType.CURRENT_USER) {
                output.writeUTF(((CatalogTablePolicyPredicate.CurrentUserPolicyPredicate)predicate).columnName());
                return;
            }
            throw new IllegalStateException("Unsupported table policy predicate type [type=" + predicate.type() + "]");
        }
    }
}

