/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.ColumnParams;
import org.apache.ignite3.internal.catalog.commands.CreateMapCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite3.internal.catalog.storage.NewMapEntry;
import org.apache.ignite3.internal.catalog.storage.NewTableEntry;
import org.apache.ignite3.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CreateMapCommand
implements CatalogCommand {
    private final String schemaName;
    private final String mapName;
    private final ColumnType keyType;
    private final ColumnType valueType;
    @Nullable
    private final String zoneName;
    @Nullable
    private final String storageProfile;

    public static CreateMapCommandBuilder builder() {
        return new Builder();
    }

    private CreateMapCommand(String schemaName, String mapName, ColumnType keyType, ColumnType valueType, @Nullable String zoneName, @Nullable String storageProfile) {
        this.schemaName = schemaName;
        this.mapName = mapName;
        this.keyType = keyType;
        this.valueType = valueType;
        this.zoneName = zoneName;
        this.storageProfile = storageProfile;
        this.validate();
    }

    private void validate() {
        if (this.schemaName != null && CatalogUtils.isSystemSchema(this.schemaName)) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Operations with reserved schemas are not allowed, schema: {}", this.schemaName));
        }
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.mapName, "Name of the map");
        if (this.keyType == null) {
            throw new CatalogValidationException("Key type can't be null.");
        }
        if (this.valueType == null) {
            throw new CatalogValidationException("Value type can't be null.");
        }
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.mapName);
        int id = catalog.objectIdGenState();
        int tableId = id++;
        int pkIndexId = id++;
        int mapId = id++;
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, "SYSTEM");
        List<CatalogTableColumnDescriptor> tableColumns = Stream.of(CreateMapCommand.toColumnParams("KEY", this.keyType, false), CreateMapCommand.toColumnParams("VAL", this.valueType, true)).map(c -> CatalogUtils.fromParams(catalog, c)).collect(Collectors.toList());
        CatalogTableDescriptor catalogTableDescriptor = CreateMapCommand.tableDescriptor(catalog, systemSchema, this.mapName, tableColumns, List.of("KEY"), tableId, pkIndexId, this.zoneName, this.storageProfile);
        return List.of(new NewTableEntry(catalogTableDescriptor), new NewIndexEntry(CreateMapCommand.indexDescriptor(this.mapName, systemSchema, catalogTableDescriptor)), new NewMapEntry(new CatalogMapDescriptor(mapId, tableId, schema.id(), this.mapName)), new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState()));
    }

    private static ColumnParams toColumnParams(String name, ColumnType columnType, boolean nullable) {
        return ColumnParams.builder().name(name).type(columnType).nullable(nullable).length(CreateMapCommand.maxLength(columnType)).precision(CreateMapCommand.maxPrecision(columnType)).scale(CreateMapCommand.maxScale(columnType)).build();
    }

    @Nullable
    private static Integer maxPrecision(ColumnType columnType) {
        int precision = CatalogUtils.getMaxPrecision(columnType);
        return precision > 0 ? Integer.valueOf(precision) : null;
    }

    @Nullable
    private static Integer maxLength(ColumnType columnType) {
        int length = CatalogUtils.getMaxLength(columnType);
        return length > 0 ? Integer.valueOf(length) : null;
    }

    @Nullable
    private static Integer maxScale(ColumnType columnType) {
        int scale = CatalogUtils.getMaxScale(columnType);
        return scale > 0 ? Integer.valueOf(scale) : null;
    }

    private static CatalogTableDescriptor tableDescriptor(Catalog catalog, CatalogSchemaDescriptor schema, String tableName, List<CatalogTableColumnDescriptor> columns, List<String> pkColumns, int tableId, int pkIndexId, @Nullable String zoneName, @Nullable String profileName) {
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, tableName);
        CatalogZoneDescriptor zone = zoneName == null ? catalog.defaultZone() : CatalogUtils.zoneOrThrow(catalog, zoneName);
        String storageProfile = profileName == null ? zone.storageProfiles().defaultProfile().storageProfile() : zone.storageProfiles().profiles().stream().map(CatalogStorageProfileDescriptor::storageProfile).filter(profileName::equalsIgnoreCase).findFirst().orElseThrow(() -> new CatalogValidationException("Storage profile with name '{}' not found.", profileName));
        return CatalogTableDescriptor.builder().id(tableId).schemaId(schema.id()).primaryKeyIndexId(pkIndexId).name(tableName).zoneId(zone.id()).columns(columns).primaryKeyColumns(pkColumns).storageProfile(storageProfile).build();
    }

    private static CatalogIndexDescriptor indexDescriptor(String mapName, CatalogSchemaDescriptor schema, CatalogTableDescriptor table) {
        String indexName = CatalogUtils.pkIndexName(mapName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        return new CatalogHashIndexDescriptor(table.primaryKeyIndexId(), indexName, table.id(), true, CatalogIndexStatus.AVAILABLE, table.primaryKeyColumns(), true);
    }

    private static class Builder
    implements CreateMapCommandBuilder {
        private String schemaName;
        private String mapName;
        private ColumnType keyType;
        private ColumnType valueType;
        @Nullable
        private String zoneName;
        @Nullable
        private String storageProfile;

        private Builder() {
        }

        @Override
        public CreateMapCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateMapCommandBuilder mapName(String name) {
            this.mapName = name;
            return this;
        }

        @Override
        public CreateMapCommandBuilder keyType(ColumnType type) {
            this.keyType = type;
            return this;
        }

        @Override
        public CreateMapCommandBuilder valueType(ColumnType type) {
            this.valueType = type;
            return this;
        }

        @Override
        public CreateMapCommandBuilder zone(@Nullable String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateMapCommandBuilder storageProfile(@Nullable String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        @Override
        public CreateMapCommand build() {
            return new CreateMapCommand(this.schemaName, this.mapName, this.keyType, this.valueType, this.zoneName, this.storageProfile);
        }
    }
}

