/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite3.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite3.internal.catalog.storage.SetExpireEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.sql.ColumnType;

public class AlterTableSetExpireCommand
extends AbstractTableCommand {
    private final String expireColumn;

    public static AlterTableSetExpireCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableSetExpireCommand(String tableName, String schemaName, boolean ifTableExists, String expireColumn) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
        this.expireColumn = expireColumn;
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        if (this.expireColumn.equals(table.expireColumn())) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Column '{}' already set as expire column.", this.expireColumn));
        }
        if (table.archiveColumn() != null) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Adding expire column '{}' is not allowed because table '{}' has archive column '{}'.", this.expireColumn, this.tableName, table.archiveColumn()));
        }
        CatalogTableColumnDescriptor column = CatalogUtils.columnOrThrow(this.schemaName, table, this.expireColumn);
        if (column.type() != ColumnType.TIMESTAMP) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Expire column must be of type TIMESTAMP WITH LOCAL TIME ZONE.", this.expireColumn));
        }
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Integer expireColumnIndexId = table.expireColumnIndexId();
        if (expireColumnIndexId != null) {
            CatalogIndexDescriptor oldIndex = catalog.index(expireColumnIndexId);
            assert (oldIndex != null);
            if (oldIndex.status() != CatalogIndexStatus.STOPPING) {
                updateEntries.add(DropIndexCommand.updateEntryForIndex(oldIndex));
            }
        }
        String indexName = CatalogUtils.generateNameForExpireColumnIndex(schema, this.tableName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        int id = catalog.objectIdGenState();
        int expireIdxId = id++;
        CatalogSortedIndexDescriptor expireColIndex = new CatalogSortedIndexDescriptor(expireIdxId, indexName, table.id(), false, List.of(new CatalogIndexColumnDescriptor(this.expireColumn, CatalogColumnCollation.ASC_NULLS_LAST)));
        updateEntries.addAll(List.of(new NewIndexEntry(expireColIndex), new SetExpireEntry(table.id(), this.expireColumn, expireIdxId), new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState())));
        return updateEntries;
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.expireColumn, "Name of the column");
    }

    private static class Builder
    implements AlterTableSetExpireCommandBuilder {
        private String expireColumn;
        private String schemaName;
        private boolean ifTableExists;
        private String tableName;

        private Builder() {
        }

        @Override
        public AlterTableSetExpireCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableSetExpireCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableSetExpireCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableSetExpireCommand(this.tableName, this.schemaName, this.ifTableExists, this.expireColumn);
        }

        @Override
        public AlterTableSetExpireCommandBuilder expireColumn(String expireColumn) {
            this.expireColumn = expireColumn;
            return this;
        }
    }
}

