/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropSecondaryZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.secondary.SecondaryDataStorages;
import org.apache.ignite3.internal.catalog.storage.DropArchiveEntry;
import org.apache.ignite3.internal.catalog.storage.DropSecondaryZoneEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class AlterTableDropSecondaryZoneCommand
extends AbstractTableCommand {
    public static AlterTableDropSecondaryZoneCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableDropSecondaryZoneCommand(String tableName, String schemaName, boolean ifTableExists) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        if (SecondaryDataStorages.noSecondaryStorageProfile(table.secondaryStorageProfile())) {
            throw new CatalogValidationException("The table has no secondary zone.");
        }
        if (table.archiveColumn() == null) {
            return List.of(new DropSecondaryZoneEntry(table.id()));
        }
        Integer archiveColumnIndexId = table.archiveColumnIndexId();
        assert (archiveColumnIndexId != null);
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, archiveColumnIndexId);
        return List.of(new DropSecondaryZoneEntry(table.id()), new DropArchiveEntry(table.id()), DropIndexCommand.updateEntryForIndex(index));
    }

    private static class Builder
    implements AlterTableDropSecondaryZoneCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableDropSecondaryZoneCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableDropSecondaryZoneCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableDropSecondaryZoneCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableDropSecondaryZoneCommand(this.tableName, this.schemaName, this.ifTableExists);
        }
    }
}

