/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.UpdateProducer;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class BulkUpdateProducer
implements UpdateProducer {
    private final List<? extends UpdateProducer> commands;

    public BulkUpdateProducer(List<? extends UpdateProducer> producers) {
        this.commands = producers;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        ArrayList<UpdateEntry> bulkUpdateEntries = new ArrayList<UpdateEntry>();
        for (UpdateProducer updateProducer : this.commands) {
            List<UpdateEntry> entries = updateProducer.get(updateContext);
            for (UpdateEntry entry : entries) {
                updateContext.updateCatalog(catalog -> entry.applyUpdate((Catalog)catalog, CatalogManager.INITIAL_TIMESTAMP));
            }
            bulkUpdateEntries.addAll(entries);
        }
        return bulkUpdateEntries;
    }
}

