/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table.nearcache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import org.apache.ignite3.table.ContinuousQueryWatermark;
import org.apache.ignite3.table.TableRowEvent;
import org.apache.ignite3.table.TableRowEventBatch;
import org.apache.ignite3.table.TableRowEventType;
import org.jetbrains.annotations.Nullable;

public class NearCacheRecordRowEventSubscriber<T>
implements Flow.Subscriber<TableRowEventBatch<T>> {
    private final Flow.Subscriber<TableRowEventBatch<Map.Entry<T, T>>> subscriber;

    public NearCacheRecordRowEventSubscriber(Flow.Subscriber<TableRowEventBatch<Map.Entry<T, T>>> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscriber.onSubscribe(subscription);
    }

    @Override
    public void onNext(final TableRowEventBatch<T> item) {
        final ArrayList<AdaptedTableRowEvent<T>> adaptedList = new ArrayList<AdaptedTableRowEvent<T>>(item.rows().size());
        for (TableRowEvent<T> rowEvent : item.rows()) {
            AdaptedTableRowEvent<T> adaptedEvent = new AdaptedTableRowEvent<T>(rowEvent);
            adaptedList.add(adaptedEvent);
        }
        TableRowEventBatch adaptedBatch = new TableRowEventBatch<Map.Entry<T, T>>(){

            @Override
            public List<TableRowEvent<Map.Entry<T, T>>> rows() {
                return adaptedList;
            }

            @Override
            public ContinuousQueryWatermark watermark() {
                return item.watermark();
            }
        };
        this.subscriber.onNext(adaptedBatch);
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    private static class AdaptedTableRowEvent<T>
    implements TableRowEvent<Map.Entry<T, T>> {
        private final TableRowEvent<T> rowEvent;

        private AdaptedTableRowEvent(TableRowEvent<T> rowEvent) {
            this.rowEvent = rowEvent;
        }

        @Override
        public TableRowEventType type() {
            return this.rowEvent.type();
        }

        @Override
        @Nullable
        public Map.Entry<T, T> entry() {
            @Nullable T entry = this.rowEvent.entry();
            return entry != null ? Map.entry(entry, entry) : null;
        }

        @Override
        @Nullable
        public Map.Entry<T, T> oldEntry() {
            @Nullable T entry = this.rowEvent.oldEntry();
            return entry != null ? Map.entry(entry, entry) : null;
        }

        @Override
        public ContinuousQueryWatermark watermark() {
            return this.rowEvent.watermark();
        }
    }
}

