/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.apache.ignite3.table.QualifiedName;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;

public class RestoreSnapshotGlobalStateSerializer
extends VersionedSerializer<RestoreSnapshotGlobalState> {
    public static final RestoreSnapshotGlobalStateSerializer INSTANCE = new RestoreSnapshotGlobalStateSerializer();
    private final GlobalSnapshotStateSerializer globalSnapshotStateSerializer = GlobalSnapshotStateSerializer.INSTANCE;

    @Override
    protected byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(RestoreSnapshotGlobalState state, IgniteDataOutput out) throws IOException {
        this.globalSnapshotStateSerializer.writeExternal(state, out);
        out.writeUuid(state.targetSnapshotId());
        out.writeVarInt(state.catalogVersion());
        RestoreSnapshotGlobalStateSerializer.writeStringSet(CollectionUtils.mapToImmutableSet(state.tableNames(), QualifiedName::toCanonicalForm), out);
        RestoreSnapshotGlobalStateSerializer.writeNullableString(state.encryptionProviderName(), out);
    }

    @Override
    protected RestoreSnapshotGlobalState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        GlobalSnapshotState globalState = (GlobalSnapshotState)this.globalSnapshotStateSerializer.readExternal(in);
        UUID targetSnapshotId = in.readUuid();
        int catalogVersion = in.readVarIntAsInt();
        Set<QualifiedName> tableNames = CollectionUtils.mapToImmutableSet(RestoreSnapshotGlobalStateSerializer.readStringSet(in), QualifiedName::parse);
        String encryptionProviderName = protoVer > 1 ? RestoreSnapshotGlobalStateSerializer.readNullableString(in) : null;
        return new RestoreSnapshotGlobalState(globalState.operationId(), globalState.status(), globalState.nodeNames(), tableNames, targetSnapshotId, catalogVersion, globalState.startTime(), globalState.description(), globalState.snapshotUri(), encryptionProviderName);
    }

    public static byte[] serialize(RestoreSnapshotGlobalState state) {
        return VersionedSerialization.toBytes(state, INSTANCE);
    }

    public static RestoreSnapshotGlobalState deserialize(byte[] bytes) {
        return VersionedSerialization.fromBytes(bytes, INSTANCE);
    }
}

