/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesFactory;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesTypeInfos;

class CreateSnapshotMessageDeserializer
implements MessageDeserializer<CreateSnapshotMessage> {
    private final CreateSnapshotMessageBuilder msg;

    CreateSnapshotMessageDeserializer(SnapshotMessagesFactory messageFactory) {
        this.msg = messageFactory.createSnapshotMessage();
    }

    @Override
    public Class<CreateSnapshotMessage> klass() {
        return CreateSnapshotMessage.class;
    }

    @Override
    public CreateSnapshotMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SnapshotMessagesTypeInfos.createSnapshotMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("destination");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.destination(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("encryptionProviderName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.encryptionProviderName(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("snapshotTypeOrdinal");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.snapshotTypeOrdinal(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readSet("tableNames", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tableNames((Set<String>)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                long tmp = reader.readLong("timestampLong");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestampLong(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CreateSnapshotMessage.class);
    }
}

