/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.jwt;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import javax.validation.Valid;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.jwt.AuthenticationApi;
import org.apache.ignite3.internal.rest.api.jwt.LoginBody;
import org.apache.ignite3.internal.security.authentication.AuthenticationManager;
import org.apache.ignite3.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite3.internal.security.authentication.UserDetails;
import org.apache.ignite3.internal.security.authentication.UsernamePasswordRequest;
import org.gridgain.internal.rest.SecurityContextAware;
import org.gridgain.internal.security.jwt.TokenManager;

@Controller(value="/management/v1/authentication")
public class AuthenticationController
implements AuthenticationApi,
ResourceHolder,
SecurityContextAware {
    private AuthenticationManager authenticationManager;
    private TokenManager tokenManager;
    private SecurityService securityService;

    public AuthenticationController(AuthenticationManager authenticationManager, TokenManager tokenManager, SecurityService securityService) {
        this.authenticationManager = authenticationManager;
        this.tokenManager = tokenManager;
        this.securityService = securityService;
    }

    private static AuthenticationRequest<?, ?> toIgniteAuthenticationRequest(LoginBody loginBody) {
        return new UsernamePasswordRequest(loginBody.username(), loginBody.password());
    }

    @Override
    public CompletableFuture<String> login(@Valid @Body LoginBody loginBody) {
        return this.authenticationManager.authenticateAsync(AuthenticationController.toIgniteAuthenticationRequest(loginBody)).thenApply(userDetails -> this.tokenManager.issueToken((UserDetails)userDetails));
    }

    @Override
    public CompletableFuture<Void> revokeToken(String token) {
        return this.secured(() -> this.tokenManager.revokeToken(token));
    }

    @Override
    public CompletableFuture<Void> revokeAllTokens(String username) {
        return this.secured(() -> this.tokenManager.revokeAllTokens(username));
    }

    @Override
    public void cleanResources() {
        this.authenticationManager = null;
        this.tokenManager = null;
        this.securityService = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

