/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.cdc;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.cdc.CdcApi;
import org.apache.ignite3.internal.rest.api.cdc.CdcReplicationStatus;
import org.apache.ignite3.internal.rest.api.cdc.Replication;
import org.apache.ignite3.internal.rest.api.cdc.ReplicationMode;
import org.apache.ignite3.internal.rest.api.cdc.Sink;
import org.apache.ignite3.internal.rest.api.cdc.SinkStatus;
import org.apache.ignite3.internal.rest.api.cdc.Source;
import org.apache.ignite3.internal.rest.api.cdc.SourceTable;
import org.apache.ignite3.internal.rest.api.cdc.Violations;
import org.gridgain.internal.cdc.api.CdcManager;
import org.gridgain.internal.cdc.api.Violation;
import org.gridgain.internal.cdc.api.replication.CdcReplicationDefinition;
import org.gridgain.internal.cdc.api.replication.CdcReplicationExecNodes;
import org.gridgain.internal.cdc.api.replication.CdcReplicationInstance;
import org.gridgain.internal.cdc.api.replication.CdcReplicationMode;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.SinkParameters;
import org.gridgain.internal.cdc.api.sink.SinkType;
import org.gridgain.internal.cdc.api.source.SourceDefinition;
import org.gridgain.internal.cdc.api.source.SourceParameters;
import org.gridgain.internal.cdc.api.source.SourceStatus;
import org.gridgain.internal.cdc.api.source.SourceTableDefinition;
import org.gridgain.internal.cdc.api.source.SourceType;
import org.gridgain.internal.rest.SecurityContextAware;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/cdc")
public class CdcController
implements CdcApi,
ResourceHolder,
SecurityContextAware {
    private SecurityService securityService;
    private CdcManager cdcManager;

    public CdcController(SecurityService securityService, CdcManager cdcManager) {
        this.securityService = securityService;
        this.cdcManager = cdcManager;
    }

    @Override
    public CompletableFuture<Collection<Source>> sources() {
        return this.secured(() -> this.cdcManager.listSources().thenApply(sources -> sources.stream().map(CdcController::sourceDefinitionToDto).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<Source> getSource(String name) {
        return this.secured(() -> this.cdcManager.getSource(name).thenApply(CdcController::sourceDefinitionToDto));
    }

    @Override
    public CompletableFuture<org.apache.ignite3.internal.rest.api.cdc.SourceStatus> getSourceStatus(String name) {
        return this.secured(() -> this.cdcManager.getSourceStatus(name).thenApply(CdcController::sourceStatusToDto));
    }

    private static org.apache.ignite3.internal.rest.api.cdc.SourceStatus sourceStatusToDto(SourceStatus sourceStatus) {
        if (sourceStatus == null) {
            return null;
        }
        return new org.apache.ignite3.internal.rest.api.cdc.SourceStatus(CdcController.sourceDefinitionToDto(sourceStatus.definition()), sourceStatus.violations().stream().map(CdcController::checkToCheckResult).collect(Collectors.toList()));
    }

    private static Violations checkToCheckResult(Violation check) {
        return new Violations(check.name(), check.errorDetails());
    }

    @Override
    public CompletableFuture<Void> createSource(Source source) {
        return this.secured(() -> this.cdcManager.createSource(this.sourceDefinitionFromDto(source)));
    }

    @Override
    public CompletableFuture<Void> deleteSource(String name) {
        return this.secured(() -> this.cdcManager.deleteSource(name));
    }

    @Override
    public CompletableFuture<Void> updateSource(String name, Source source) {
        return this.secured(() -> this.cdcManager.updateSource(this.sourceDefinitionFromDto(source)));
    }

    @Override
    public CompletableFuture<Collection<Sink>> sinks() {
        return this.secured(() -> this.cdcManager.listSinks().thenApply(sources -> sources.stream().map(CdcController::sinkDefinitionToDto).collect(Collectors.toList())));
    }

    private static Sink sinkDefinitionToDto(SinkDefinition sinkDefinition) {
        return new Sink(CdcController.sinkTypeToDto(sinkDefinition.type()), sinkDefinition.name(), CdcController.sinkParametersToMap(sinkDefinition.parameters()), sinkDefinition.createTableIfNotExists());
    }

    @Nullable
    private static Map<String, Object> sinkParametersToMap(SinkParameters parameters) {
        if (parameters == null) {
            return null;
        }
        Map<String, String> map = parameters.parameters();
        return map == null ? null : new HashMap<String, String>(map);
    }

    private static org.apache.ignite3.internal.rest.api.cdc.SinkType sinkTypeToDto(SinkType type) {
        switch (type) {
            case ICEBERG: {
                return org.apache.ignite3.internal.rest.api.cdc.SinkType.ICEBERG;
            }
        }
        throw new IllegalArgumentException("Unknown sink type: " + type);
    }

    @Override
    public CompletableFuture<Sink> getSink(String name) {
        return this.secured(() -> this.cdcManager.getSink(name).thenApply(CdcController::sinkDefinitionToDto));
    }

    @Override
    public CompletableFuture<SinkStatus> getSinkStatus(String name) {
        return this.secured(() -> this.cdcManager.getSinkStatus(name).thenApply(CdcController::sinkStatusToDto));
    }

    private static SinkStatus sinkStatusToDto(org.gridgain.internal.cdc.api.sink.SinkStatus sinkStatus) {
        if (sinkStatus == null) {
            return null;
        }
        return new SinkStatus(CdcController.sinkDefinitionToDto(sinkStatus.definition()), sinkStatus.violations().stream().map(CdcController::checkToCheckResult).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> createSink(Sink sink) {
        return this.secured(() -> this.cdcManager.createSink(SinkDefinition.builder().type(this.sinkTypeFromDto(sink.type())).name(sink.name()).parameters(new SinkParameters(sink.parameters() == null ? Map.of() : CdcController.asStringMap(sink.parameters()))).build()));
    }

    private static Map<String, String> asStringMap(Map<String, Object> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            stringMap.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return stringMap;
    }

    private SinkType sinkTypeFromDto(org.apache.ignite3.internal.rest.api.cdc.SinkType type) {
        switch (type) {
            case ICEBERG: {
                return SinkType.ICEBERG;
            }
        }
        throw new IllegalArgumentException("Unknown sink type: " + type);
    }

    @Override
    public CompletableFuture<Void> deleteSink(String name) {
        return this.secured(() -> this.cdcManager.deleteSink(name));
    }

    @Override
    public CompletableFuture<Void> updateSink(String name, Sink sink) {
        return this.secured(() -> this.cdcManager.updateSink(SinkDefinition.builder().type(this.sinkTypeFromDto(sink.type())).name(name).parameters(new SinkParameters(sink.parameters() == null ? Map.of() : CdcController.asStringMap(sink.parameters()))).build()));
    }

    @Override
    public CompletableFuture<Collection<Replication>> replications() {
        return this.secured(() -> this.cdcManager.listReplications().thenApply(replicationInstances -> replicationInstances.stream().map(CdcController::replicationInstanceToDto).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<Replication> getCdcReplication(String name) {
        return this.secured(() -> this.cdcManager.getReplication(name).thenApply(CdcController::replicationInstanceToDto));
    }

    @Override
    public CompletableFuture<Void> createCdcReplication(Replication replication) {
        return this.secured(() -> this.cdcManager.createReplication(CdcReplicationDefinition.builder().name(replication.name()).sinkName(replication.sinkName()).sourceName(replication.sourceName()).mode(this.modeFromDto(replication.mode())).executionNodes(new CdcReplicationExecNodes(replication.executionNodes() == null ? List.of() : replication.executionNodes())).build()).thenApply(ignore -> null));
    }

    private CdcReplicationMode modeFromDto(ReplicationMode mode) {
        switch (mode) {
            case ALL: {
                return CdcReplicationMode.ALL;
            }
            case NEW_DATA: {
                return CdcReplicationMode.NEW_DATA;
            }
        }
        throw new IllegalArgumentException("Unknown replication mode: " + mode);
    }

    @Override
    public CompletableFuture<Void> deleteCdcReplication(String name) {
        return this.secured(() -> this.cdcManager.deleteReplication(name));
    }

    @Override
    public CompletableFuture<Void> startCdcReplication(String name) {
        return this.secured(() -> this.cdcManager.startReplication(name).thenApply(ignore -> null));
    }

    @Override
    public CompletableFuture<Void> stopCdcReplication(String name) {
        return this.secured(() -> this.cdcManager.stopReplication(name).thenApply(ignore -> null));
    }

    @Override
    public void cleanResources() {
        this.cdcManager = null;
        this.securityService = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    private static Source sourceDefinitionToDto(SourceDefinition sourceDefinition) {
        return new Source(CdcController.sourceTypeToDto(sourceDefinition.type()), sourceDefinition.name(), CdcController.sourceParametersToMap(sourceDefinition.parameters()), CdcController.sourceTablesDefinitionToDto(sourceDefinition.tables()));
    }

    @Nullable
    private static List<SourceTable> sourceTablesDefinitionToDto(@Nullable SourceTableDefinition[] tables) {
        if (tables == null) {
            return null;
        }
        return Stream.of(tables).map(table -> new SourceTable(table.schema(), table.name())).collect(Collectors.toList());
    }

    @Nullable
    private static Map<String, Object> sourceParametersToMap(@Nullable SourceParameters parameters) {
        if (parameters == null) {
            return null;
        }
        Map<String, Object> map = parameters.parameters();
        return map == null ? null : new HashMap<String, Object>(map);
    }

    private static org.apache.ignite3.internal.rest.api.cdc.SourceType sourceTypeToDto(SourceType type) {
        switch (type) {
            case GRIDGAIN: {
                return org.apache.ignite3.internal.rest.api.cdc.SourceType.GRIDGAIN;
            }
        }
        throw new IllegalArgumentException("Unknown source type: " + type);
    }

    private SourceDefinition sourceDefinitionFromDto(Source source) {
        return SourceDefinition.builder().type(this.sourceTypeFromDto(source.type())).name(source.name()).parameters(new SourceParameters(source.parameters())).tables(this.sourceTablesDefinitionFromDto(source.tables())).build();
    }

    @Nullable
    private SourceTableDefinition[] sourceTablesDefinitionFromDto(@Nullable List<SourceTable> tables) {
        if (tables == null) {
            return null;
        }
        return (SourceTableDefinition[])tables.stream().map(table -> new SourceTableDefinition(table.schema(), table.name())).toArray(SourceTableDefinition[]::new);
    }

    private SourceType sourceTypeFromDto(org.apache.ignite3.internal.rest.api.cdc.SourceType type) {
        switch (type) {
            case GRIDGAIN: {
                return SourceType.GRIDGAIN;
            }
        }
        throw new IllegalArgumentException("Unknown source type: " + type);
    }

    private static Replication replicationInstanceToDto(CdcReplicationInstance instance) {
        return Replication.builder().name(instance.name()).sinkName(instance.sinkName()).sourceName(instance.sourceName()).mode(CdcController.modeToDto(instance.mode())).executionNodes(instance.executionNodes().nodes()).status(CdcController.replicationStatusToDto(instance.status())).build();
    }

    @Nullable
    private static CdcReplicationStatus replicationStatusToDto(org.gridgain.internal.cdc.api.replication.CdcReplicationStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case CREATED: {
                return CdcReplicationStatus.CREATED;
            }
            case RUNNING: {
                return CdcReplicationStatus.RUNNING;
            }
            case STOPPED: {
                return CdcReplicationStatus.STOPPED;
            }
            case FAILED: {
                return CdcReplicationStatus.FAILED;
            }
        }
        throw new IllegalArgumentException("Unknown replication status: " + status);
    }

    private static ReplicationMode modeToDto(CdcReplicationMode mode) {
        switch (mode) {
            case ALL: {
                return ReplicationMode.ALL;
            }
            case NEW_DATA: {
                return ReplicationMode.NEW_DATA;
            }
        }
        throw new IllegalArgumentException("Unknown replication mode: " + mode);
    }
}

