/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.users;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.configuration.ConfigurationChangeException;
import org.apache.ignite3.configuration.ConfigurationNodeAlreadyExistException;
import org.apache.ignite3.configuration.NamedConfigurationTree;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.internal.security.authentication.basic.BasicAuthenticationProviderConfiguration;
import org.apache.ignite3.internal.security.authentication.basic.BasicUserChange;
import org.apache.ignite3.internal.security.authentication.basic.BasicUserConfiguration;
import org.apache.ignite3.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationConfiguration;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationProviderChange;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationProviderConfiguration;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationProviderView;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.IgniteException;
import org.gridgain.internal.rbac.password.PasswordEncoding;
import org.gridgain.internal.rbac.store.LowerCaseString;
import org.gridgain.internal.rbac.store.OperationResult;
import org.gridgain.internal.rbac.users.BasicProviderNotFoundException;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rbac.users.UserStore;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUserStore
implements UserStore {
    private final AuthenticationConfiguration authenticationConfiguration;

    public ConfigurationUserStore(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    @Override
    public CompletableFuture<OperationResult> updateIfExists(LowerCaseString username, Function<User, User> update) {
        BasicUserConfiguration userEntry = this.basicProvider().users().get(username.value());
        if (userEntry == null) {
            return CompletableFuture.completedFuture(OperationResult.USER_NOT_FOUND);
        }
        return userEntry.change(provider -> ConfigurationUserStore.updateUser(provider, update)).thenApply(unused -> OperationResult.SUCCESS);
    }

    private static void updateUser(BasicUserChange userEntry, Function<User, User> userChanger) {
        User user = userChanger.apply(ConfigurationUserStore.toUser(userEntry));
        ConfigurationUserStore.updateUserEntryFromUser(user, userEntry);
    }

    @Override
    public CompletableFuture<OperationResult> putIfNotExists(LowerCaseString username, User user) {
        return this.basicProvider().users().change(users -> users.create(username.value(), change -> ConfigurationUserStore.updateUserEntryFromUser(user, change))).handle((unused, throwable) -> {
            if (throwable != null) {
                Throwable unwrap = ExceptionUtils.unwrapCause(throwable);
                if (unwrap instanceof ConfigurationChangeException && unwrap.getCause() instanceof ConfigurationNodeAlreadyExistException) {
                    return OperationResult.USER_EXISTS;
                }
                if (unwrap instanceof ConfigurationNodeAlreadyExistException) {
                    return OperationResult.USER_EXISTS;
                }
                throw new CompletionException((Throwable)throwable);
            }
            return OperationResult.SUCCESS;
        });
    }

    @Override
    public CompletableFuture<OperationResult> removeIfExists(LowerCaseString username) {
        User user = this.doGet(username);
        if (user == null) {
            return CompletableFuture.completedFuture(OperationResult.USER_NOT_FOUND);
        }
        return this.basicProvider().users().change(users -> users.delete(username.value())).handle((unused, throwable) -> {
            Throwable unwrap;
            if (throwable != null && (unwrap = ExceptionUtils.unwrapCause(throwable)) instanceof ConfigurationChangeException) {
                throw new IgniteException(GridgainErrorGroups.Rbac.USER_ASSIGNMENT_EXISTS_ERR, unwrap.getCause().getMessage());
            }
            return OperationResult.SUCCESS;
        });
    }

    @Override
    public Collection<User> getAll() {
        return this.userStream().collect(Collectors.toSet());
    }

    @Override
    public Map<LowerCaseString, User> getAllWithKeys() {
        return this.userStream().collect(Collectors.toMap(user -> LowerCaseString.from(user.username()), Function.identity()));
    }

    private Stream<User> userStream() {
        return ((NamedListView)this.basicProvider().users().value()).stream().map(ConfigurationUserStore::toUser);
    }

    @Override
    public User get(LowerCaseString username) {
        return this.doGet(username);
    }

    @Override
    public List<User> get(LowerCaseString ... usernames) {
        return Arrays.stream(usernames).map(this::doGet).collect(Collectors.toList());
    }

    @Nullable
    private User doGet(LowerCaseString username) {
        BasicUserConfiguration basicUserConfiguration = this.basicProvider().users().get(username.value());
        if (basicUserConfiguration == null) {
            return null;
        }
        return ConfigurationUserStore.toUser((BasicUserView)basicUserConfiguration.value());
    }

    private static User toUser(BasicUserView view) {
        return User.builder().username(view.displayName()).password(view.password()).passwordEncoding(PasswordEncoding.valueOf(view.passwordEncoding().toUpperCase())).addRoles(Set.of(view.roles())).build();
    }

    private static void updateUserEntryFromUser(User user, BasicUserChange userEntry) {
        Set<String> roles;
        PasswordEncoding passwordEncoding;
        String password;
        String username = user.username();
        if (username != null) {
            userEntry.changeDisplayName(username);
        }
        if ((password = user.password()) != null) {
            userEntry.changePassword(password);
        }
        if ((passwordEncoding = user.passwordEncoding()) != null) {
            userEntry.changePasswordEncoding(passwordEncoding.name().toUpperCase());
        }
        if ((roles = user.roles()) != null) {
            userEntry.changeRoles((String[])roles.toArray(String[]::new));
        }
    }

    private BasicAuthenticationProviderConfiguration basicProvider() {
        NamedConfigurationTree<AuthenticationProviderConfiguration, AuthenticationProviderView, AuthenticationProviderChange> providers = this.authenticationConfiguration.providers();
        return providers.internalIds().stream().map(providers::get).filter(BasicAuthenticationProviderConfiguration.class::isInstance).map(BasicAuthenticationProviderConfiguration.class::cast).findFirst().orElseThrow(BasicProviderNotFoundException::new);
    }
}

