/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.metastorage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import org.apache.ignite3.internal.lang.ByteArray;
import org.gridgain.internal.pitr.TableName;

public class PitrMetaStorageKeys {
    private static final ByteOrder BYTE_UTILS_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final ByteArray PITR_RECOVER_GLOBAL_PREFIX = new ByteArray("gridgain.pitr.recover.global.");
    private static final byte[] PITR_COORDINATOR_TERM_PREFIX = "gridgain.pitr.coordinator.".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PITR_RECOVER_LOCAL_PREFIX = "gridgain.pitr.recover.local.".getBytes(StandardCharsets.UTF_8);
    private static final String PITR_LOCK_PREFIX = "gridgain.pitr.recover.lock.";

    public static ByteArray pitrGlobalStatePrefix() {
        return PITR_RECOVER_GLOBAL_PREFIX;
    }

    public static ByteArray pitrGlobalStateKey(UUID operationId) {
        return PitrMetaStorageKeys.buildKey(PITR_RECOVER_GLOBAL_PREFIX.bytes(), operationId);
    }

    public static ByteArray pitrLocalStatePrefix(UUID operationId) {
        return PitrMetaStorageKeys.buildKey(PITR_RECOVER_LOCAL_PREFIX, operationId);
    }

    public static ByteArray pitrLocalStateKey(UUID operationId, String nodeName) {
        return PitrMetaStorageKeys.buildKey(PITR_RECOVER_LOCAL_PREFIX, operationId, nodeName);
    }

    public static String nodeNameFromPitrLocalStateKey(byte[] key) {
        return PitrMetaStorageKeys.nodeNameFromKey(PITR_RECOVER_LOCAL_PREFIX, key);
    }

    private static String nodeNameFromKey(byte[] prefix, byte[] key) {
        int idOffset = PitrMetaStorageKeys.indexOf(key, (byte)46, prefix.length, key.length);
        int offset = idOffset + 1;
        return new String(key, offset, key.length - offset, StandardCharsets.UTF_8);
    }

    public static ByteArray pitrCoordinatorTermKey(UUID operationId) {
        return PitrMetaStorageKeys.buildKey(PITR_COORDINATOR_TERM_PREFIX, operationId);
    }

    private static ByteArray buildKey(byte[] prefix, UUID operationId) {
        byte[] idBytes = operationId.toString().getBytes(StandardCharsets.UTF_8);
        byte[] key = ByteBuffer.allocate(prefix.length + idBytes.length).order(BYTE_UTILS_BYTE_ORDER).put(prefix).put(idBytes).array();
        return new ByteArray(key);
    }

    private static ByteArray buildKey(byte[] prefix, UUID operationId, String nodeName) {
        byte[] idBytes = operationId.toString().getBytes(StandardCharsets.UTF_8);
        byte[] nodeNameBytes = nodeName.getBytes(StandardCharsets.UTF_8);
        int keyLength = prefix.length + idBytes.length + 1 + nodeNameBytes.length;
        byte[] key = ByteBuffer.allocate(keyLength).order(BYTE_UTILS_BYTE_ORDER).put(prefix).put(idBytes).put((byte)46).put(nodeNameBytes).array();
        return new ByteArray(key);
    }

    public static ByteArray buildTableLockKey(TableName tableName) {
        return new ByteArray(PITR_LOCK_PREFIX + tableName.schema() + "." + tableName.name());
    }

    private static int indexOf(byte[] array, byte target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        throw new IllegalStateException("Could not find '" + target + "' in array " + Arrays.toString(array));
    }
}

