/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.event;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite3.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.gridgain.internal.encryption.event.EncryptionEventParameters;
import org.jetbrains.annotations.Nullable;

public class KeyEncryptionKeyEventFactory
implements ConfigurationNamedListListener<EncryptionView> {
    private final Function<EncryptionEventParameters, CompletableFuture<Void>> notifier;

    public KeyEncryptionKeyEventFactory(Function<EncryptionEventParameters, CompletableFuture<Void>> notifier) {
        this.notifier = notifier;
    }

    @Override
    public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<EncryptionView> ctx) {
        @Nullable String oldKeyProvider = KeyEncryptionKeyEventFactory.getActiveProvider(ctx.oldValue());
        if (oldKeyProvider == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        @Nullable String newKeyProvider = KeyEncryptionKeyEventFactory.getActiveProvider(ctx.newValue());
        if (Objects.equals(oldKeyProvider, newKeyProvider)) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.notifier.apply(EncryptionEventParameters.updated());
    }

    @Nullable
    private static String getActiveProvider(@Nullable EncryptionView value) {
        if (value == null || !value.enabled()) {
            return null;
        }
        return value.activeProvider();
    }
}

