/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTableConverters;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.util.PlainTableRenderer;
import org.apache.ignite3.rest.client.model.TableRecoveryStatus;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStateCallOutput;

public class RecoveryStateDecorator
implements Decorator<TablesRecoveryStateCallOutput, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"table", "recovery progress", "status"};
    private final boolean plain;

    public RecoveryStateDecorator(boolean plain) {
        this.plain = plain;
    }

    private static String[][] progressContent(Map<String, Long> data, TableRecoveryStatus status) {
        ArrayList result = new ArrayList();
        data.forEach((table, rows) -> result.add(new String[]{table, String.format("%d rows", rows), status.toString()}));
        return (String[][])result.toArray((T[])new String[0][]);
    }

    @Override
    public TerminalOutput decorate(TablesRecoveryStateCallOutput output) {
        Map<String, Long> data = output.progress();
        if (data == null || data.isEmpty()) {
            return () -> "";
        }
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, RecoveryStateDecorator.progressContent(data, output.status()));
        }
        return () -> FlipTableConverters.fromObjects((String[])HEADERS, (Object[][])RecoveryStateDecorator.progressContent(data, output.status()));
    }
}

