/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.replication.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.cdc.replication.ReplicationNameCallInput;
import org.gridgain.internal.cli.call.cdc.replication.StatusReplicationCall;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"CDC replication status command"})
public class CdcReplicationStatusReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC replication."})
    private String name;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private StatusReplicationCall statusReplicationCall;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.statusReplicationCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot get replication status")).print());
    }

    private ReplicationNameCallInput input(String url) {
        return ReplicationNameCallInput.builder().clusterUrl(url).name(this.name).build();
    }
}

