/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.sink;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.CdcManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.SinkStatus;
import org.gridgain.internal.cli.call.cdc.sink.SinkNameCallInput;

@Singleton
public class StatusSinkCall
implements Call<SinkNameCallInput, SinkStatus> {
    private final ApiClientFactory apiClientFactory;

    public StatusSinkCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<SinkStatus> execute(SinkNameCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            return DefaultCallOutput.success(new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).getSinkStatus(input.name()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

