/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.sink;

import java.util.Map;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.rest.client.model.SinkType;

public class SinkCallInput
implements CallInput {
    private final String name;
    private final String clusterUrl;
    private final SinkType type;
    private final Map<String, Object> params;
    private final boolean createTableIfNotExists;

    private SinkCallInput(String name, String clusterUrl, SinkType type, Map<String, Object> params, boolean createTableIfNotExists) {
        this.name = name;
        this.clusterUrl = clusterUrl;
        this.type = type;
        this.params = params;
        this.createTableIfNotExists = createTableIfNotExists;
    }

    public String name() {
        return this.name;
    }

    public String clusterUrl() {
        return this.clusterUrl;
    }

    public SinkType type() {
        return this.type;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public boolean createTableIfNotExists() {
        return this.createTableIfNotExists;
    }

    public static SinkCallInputBuilder builder() {
        return new SinkCallInputBuilder();
    }

    public static class SinkCallInputBuilder {
        private String name;
        private String clusterUrl;
        private SinkType type;
        private Map<String, Object> params;
        private boolean createTableIfNotExists = true;

        public SinkCallInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SinkCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        public SinkCallInputBuilder type(SinkType type) {
            this.type = type;
            return this;
        }

        public SinkCallInputBuilder parameters(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public SinkCallInputBuilder createTableIfNotExists(boolean createTableIfNotExists) {
            this.createTableIfNotExists = createTableIfNotExists;
            return this;
        }

        public SinkCallInput build() {
            return new SinkCallInput(this.name, this.clusterUrl, this.type, this.params, this.createTableIfNotExists);
        }
    }
}

