/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.invoker.ApiResponse;
import org.apache.ignite3.rest.client.invoker.Configuration;
import org.apache.ignite3.rest.client.invoker.Pair;
import org.apache.ignite3.rest.client.model.Role;

public class RoleManagementApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RoleManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleManagementApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createRoleCall(Role role, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Role localVarPostBody = role;
        String localVarPath = "/management/v1/rbac/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRoleValidateBeforeCall(Role role, ApiCallback _callback) throws ApiException {
        if (role == null) {
            throw new ApiException("Missing the required parameter 'role' when calling createRole(Async)");
        }
        return this.createRoleCall(role, _callback);
    }

    public void createRole(Role role) throws ApiException {
        this.createRoleWithHttpInfo(role);
    }

    public ApiResponse<Void> createRoleWithHttpInfo(Role role) throws ApiException {
        Call localVarCall = this.createRoleValidateBeforeCall(role, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createRoleAsync(Role role, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createRoleValidateBeforeCall(role, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteRoleCall(String roleName, Boolean revoke, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/rbac/roles/{roleName}".replace("{roleName}", this.localVarApiClient.escapeString(roleName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (revoke != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("revoke", revoke));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRoleValidateBeforeCall(String roleName, Boolean revoke, ApiCallback _callback) throws ApiException {
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling deleteRole(Async)");
        }
        if (revoke == null) {
            throw new ApiException("Missing the required parameter 'revoke' when calling deleteRole(Async)");
        }
        return this.deleteRoleCall(roleName, revoke, _callback);
    }

    public void deleteRole(String roleName, Boolean revoke) throws ApiException {
        this.deleteRoleWithHttpInfo(roleName, revoke);
    }

    public ApiResponse<Void> deleteRoleWithHttpInfo(String roleName, Boolean revoke) throws ApiException {
        Call localVarCall = this.deleteRoleValidateBeforeCall(roleName, revoke, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRoleAsync(String roleName, Boolean revoke, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRoleValidateBeforeCall(roleName, revoke, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getRoleCall(String roleName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/rbac/roles/{roleName}".replace("{roleName}", this.localVarApiClient.escapeString(roleName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRoleValidateBeforeCall(String roleName, ApiCallback _callback) throws ApiException {
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling getRole(Async)");
        }
        return this.getRoleCall(roleName, _callback);
    }

    public Role getRole(String roleName) throws ApiException {
        ApiResponse<Role> localVarResp = this.getRoleWithHttpInfo(roleName);
        return localVarResp.getData();
    }

    public ApiResponse<Role> getRoleWithHttpInfo(String roleName) throws ApiException {
        Call localVarCall = this.getRoleValidateBeforeCall(roleName, null);
        Type localVarReturnType = new TypeToken<Role>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRoleAsync(String roleName, ApiCallback<Role> _callback) throws ApiException {
        Call localVarCall = this.getRoleValidateBeforeCall(roleName, _callback);
        Type localVarReturnType = new TypeToken<Role>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRolesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/rbac/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRolesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getRolesCall(_callback);
    }

    public List<Role> getRoles() throws ApiException {
        ApiResponse<List<Role>> localVarResp = this.getRolesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Role>> getRolesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getRolesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Role>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRolesAsync(ApiCallback<List<Role>> _callback) throws ApiException {
        Call localVarCall = this.getRolesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Role>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

