/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.ErrorResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class ErrorResponseDeserializer
implements MessageDeserializer<RpcRequests.ErrorResponse> {
    private final ErrorResponseBuilder msg;

    ErrorResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.errorResponse();
    }

    @Override
    public Class<RpcRequests.ErrorResponse> klass() {
        return RpcRequests.ErrorResponse.class;
    }

    @Override
    public RpcRequests.ErrorResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.errorResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("errorCode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.errorCode(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("errorMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.errorMsg((String)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readString("leaderId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.leaderId((String)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readBoxedLong("maxObservableSafeTimeViolatedValue");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.maxObservableSafeTimeViolatedValue((Long)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ErrorResponse.class);
    }
}

