/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import java.util.Collection;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.entity.EntryMetaBuilder;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;

class EntryMetaDeserializer
implements MessageDeserializer<RaftOutter.EntryMeta> {
    private final EntryMetaBuilder msg;

    EntryMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.entryMeta();
    }

    @Override
    public Class<RaftOutter.EntryMeta> klass() {
        return RaftOutter.EntryMeta.class;
    }

    @Override
    public RaftOutter.EntryMeta getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.entryMeta());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("checksum");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.checksum(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("dataLen");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.dataLen(tmp);
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("hasChecksum");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.hasChecksum(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readCollection("learnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.learnersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldLearnersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldPeersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readCollection("peersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.peersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 8: {
                EnumOutter.EntryType tmp;
                int shiftedId = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                EnumOutter.EntryType entryType = tmp = shiftedId == 0 ? null : EnumOutter.EntryType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.type(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RaftOutter.EntryMeta.class);
    }
}

