/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.cache.CacheStore;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteReadWriteTransaction
implements InternalTransaction {
    private static final String EXCEPTION_MSG = "Remote transaction should never be finished directly";
    private final UUID txId;
    private final TablePartitionId commitGroupId;
    private final long timeout;
    private final UUID coord;
    private final String localNodeConsistentId;
    @IgniteToStringExclude
    @Nullable
    private PendingTxPartitionEnlistment enlistment;

    RemoteReadWriteTransaction(UUID txId, TablePartitionId commitGroupId, UUID coord, long token, InternalClusterNode localNode, long timeout) {
        this.txId = txId;
        this.commitGroupId = commitGroupId;
        this.coord = coord;
        this.timeout = timeout;
        this.localNodeConsistentId = localNode.name();
        this.enlistment = token == 0L ? null : new PendingTxPartitionEnlistment(this.localNodeConsistentId, token);
    }

    @Override
    public void commit() throws TransactionException {
        throw new AssertionError((Object)EXCEPTION_MSG);
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        throw new AssertionError((Object)EXCEPTION_MSG);
    }

    @Override
    public void rollback() throws TransactionException {
        throw new AssertionError((Object)EXCEPTION_MSG);
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        throw new AssertionError((Object)EXCEPTION_MSG);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public UUID id() {
        return this.txId;
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ReplicationGroupId replicationGroupId) {
        return this.enlistment;
    }

    @Override
    public boolean assignCommitPartition(ReplicationGroupId replicationGroupId) {
        return false;
    }

    @Override
    public TablePartitionId commitPartition() {
        return this.commitGroupId;
    }

    @Override
    public void enlist(ReplicationGroupId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
        if (!this.localNodeConsistentId.equals(primaryNodeConsistentId)) {
            throw new TransactionException(ErrorGroups.Replicator.REPLICA_MISS_ERR, IgniteStringFormatter.format("The primary replica has changed [txId={}, expectedPrimaryReplicaConsistentId={}, currentPrimaryReplicaConsistentId={}].", this.txId, this.localNodeConsistentId, primaryNodeConsistentId));
        }
        this.enlistment = new PendingTxPartitionEnlistment(primaryNodeConsistentId, consistencyToken, tableId);
    }

    @Override
    @Nullable
    public HybridTimestamp readTimestamp() {
        return null;
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return TransactionIds.beginTimestamp(this.txId);
    }

    @Override
    public UUID coordinatorId() {
        return this.coord;
    }

    @Override
    public boolean implicit() {
        return false;
    }

    @Override
    public boolean remote() {
        return true;
    }

    @Override
    public CompletableFuture<Void> finish(boolean commit, @Nullable HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        return null;
    }

    @Override
    public boolean isFinishingOrFinished() {
        return false;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public CompletableFuture<Void> kill() {
        return null;
    }

    @Override
    public <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        return null;
    }

    @Override
    public boolean external() {
        return false;
    }

    @Override
    public void external(boolean external) {
    }

    public String toString() {
        return S.toString(RemoteReadWriteTransaction.class, this);
    }
}

