/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.cache.CacheStore;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.tx.impl.IgniteAbstractTransactionImpl;
import org.apache.ignite3.internal.tx.impl.TransactionsExceptionMapperUtil;
import org.apache.ignite3.internal.tx.impl.TxIdAndTimestamp;
import org.apache.ignite3.internal.tx.impl.TxManagerImpl;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.tx.TransactionException;
import org.gridgain.lang.GridgainErrorGroups;

public class ReadOnlyTransactionImpl
extends IgniteAbstractTransactionImpl {
    private final HybridTimestamp readTimestamp;
    private final AtomicBoolean finishGuard = new AtomicBoolean();
    private final CompletableFuture<Void> txFuture;

    ReadOnlyTransactionImpl(TxManagerImpl txManager, HybridTimestampTracker observableTsTracker, UUID id, UUID txCoordinatorId, long timeout, HybridTimestamp readTimestamp, CompletableFuture<Void> txFuture) {
        super(txManager, observableTsTracker, id, txCoordinatorId, false, timeout);
        this.readTimestamp = readTimestamp;
        this.txFuture = txFuture;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public void enlist(ReplicationGroupId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ReplicationGroupId replicationGroupId) {
        return null;
    }

    @Override
    public boolean assignCommitPartition(ReplicationGroupId commitPartitionId) {
        return true;
    }

    @Override
    public TablePartitionId commitPartition() {
        return null;
    }

    @Override
    public boolean external() {
        return false;
    }

    @Override
    public void external(boolean external) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(true, this.readTimestamp, false, false), ErrorGroups.Transactions.TX_COMMIT_ERR);
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, this.readTimestamp, false, false), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> rollbackTimeoutExceededAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, this.readTimestamp, false, true), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> finish(boolean commitIntent, HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        assert (!full) : "Read-only transactions cannot be full.";
        assert (!commitIntent || !timeoutExceeded) : "Transaction cannot commit with timeout exceeded.";
        if (!this.finishGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.observableTsTracker.update(executionTimestamp);
        this.txFuture.complete(null);
        ((TxManagerImpl)this.txManager).onCompleteReadOnlyTransaction(commitIntent, new TxIdAndTimestamp(this.readTimestamp, this.id()), timeoutExceeded);
        this.timeoutExceeded = timeoutExceeded;
        return this.txFuture;
    }

    @Override
    public <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        throw new TransactionException(GridgainErrorGroups.Cache.TX_INCOMPATIBLE_OPERATION_ERR, IgniteStringFormatter.format("Requested operation is incompatible with cache or table type [txId={}, cache={}]", this.id(), true));
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.finishGuard.get();
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.finish(false, this.readTimestamp, false, false);
    }
}

