/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator.secondary;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.table.distributed.replicator.secondary.SecondaryStorageReplicator;
import org.jetbrains.annotations.Nullable;

class ZoneSecondaryStorageReplicator {
    private final Map<Integer, CompletableFuture<SecondaryStorageReplicator>> tableReplicators = new HashMap<Integer, CompletableFuture<SecondaryStorageReplicator>>();

    ZoneSecondaryStorageReplicator() {
    }

    void addReplication(int tableId, CompletableFuture<SecondaryStorageReplicator> replicationFuture) {
        CompletableFuture<SecondaryStorageReplicator> previousReplication = this.tableReplicators.put(tableId, replicationFuture);
        assert (previousReplication == null) : "Replication for tableId=" + tableId + " is already started";
    }

    @Nullable
    CompletableFuture<SecondaryStorageReplicator> removeReplication(int tableId) {
        return this.tableReplicators.remove(tableId);
    }

    CompletableFuture<Void> stop() {
        CompletableFuture[] futures = (CompletableFuture[])this.tableReplicators.values().stream().map(replicationFuture -> replicationFuture.thenAccept(SecondaryStorageReplicator::stop)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    boolean hasReplication(int tableId) {
        return this.tableReplicators.containsKey(tableId);
    }
}

