/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.partition.replicator.schemacompat.IncompatibleSchemaVersionException;
import org.apache.ignite3.internal.partition.replicator.schemacompat.InternalSchemaVersionMismatchException;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.TableViewRowConverter;
import org.apache.ignite3.internal.table.criteria.CriteriaExceptionMapperUtil;
import org.apache.ignite3.internal.table.criteria.CursorAdapter;
import org.apache.ignite3.internal.table.criteria.QueryCriteriaAsyncCursor;
import org.apache.ignite3.internal.table.criteria.SqlSerializer;
import org.apache.ignite3.internal.table.distributed.TableUtils;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.lang.AsyncCursor;
import org.apache.ignite3.lang.Cursor;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.Statement;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.criteria.Criteria;
import org.apache.ignite3.table.criteria.CriteriaQueryOptions;
import org.apache.ignite3.table.criteria.CriteriaQuerySource;
import org.apache.ignite3.tx.Transaction;
import org.jetbrains.annotations.Nullable;

abstract class AbstractTableView<R>
implements CriteriaQuerySource<R> {
    protected final InternalTable tbl;
    protected final SchemaVersions schemaVersions;
    protected final TableViewRowConverter rowConverter;
    protected final IgniteSql sql;
    protected final MarshallersProvider marshallers;

    AbstractTableView(InternalTable tbl, SchemaVersions schemaVersions, SchemaRegistry schemaReg, IgniteSql sql, MarshallersProvider marshallers) {
        this.tbl = tbl;
        this.schemaVersions = schemaVersions;
        this.sql = sql;
        this.marshallers = marshallers;
        this.rowConverter = new TableViewRowConverter(schemaReg);
    }

    protected final <T> CompletableFuture<T> doOperation(@Nullable Transaction tx, KvAction<T> action) {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.withSchemaSync(tx, action));
    }

    protected final <T> CompletableFuture<T> withSchemaSync(@Nullable Transaction tx, KvAction<T> action) {
        return this.withSchemaSync((InternalTransaction)tx, null, action);
    }

    private <T> CompletableFuture<T> withSchemaSync(@Nullable InternalTransaction tx, @Nullable Integer previousSchemaVersion, KvAction<T> action) {
        CompletableFuture<Integer> schemaVersionFuture = tx == null ? this.schemaVersions.schemaVersionAtCurrentTime(this.tbl.tableId()) : this.schemaVersions.schemaVersionAt(tx.schemaTimestamp(), this.tbl.tableId());
        return ((CompletableFuture)schemaVersionFuture.thenCompose(schemaVersion -> action.act((int)schemaVersion).handle((res, ex) -> {
            if (ex == null) {
                return CompletableFuture.completedFuture(res);
            }
            if (ExceptionUtils.isOrCausedBy(InternalSchemaVersionMismatchException.class, ex)) {
                assert (TableUtils.isDirectFlowApplicable(tx)) : "Only for direct flow applicable tx a retry might be requested";
                AbstractTableView.assertSchemaVersionIncreased(previousSchemaVersion, schemaVersion);
                return this.withSchemaSync(tx, (Integer)schemaVersion, action);
            }
            if (tx == null && ExceptionUtils.isOrCausedBy(IncompatibleSchemaVersionException.class, ex)) {
                AbstractTableView.assertSchemaVersionIncreased(previousSchemaVersion, schemaVersion);
                return this.withSchemaSync(tx, (Integer)schemaVersion, action);
            }
            return CompletableFuture.failedFuture(ex);
        }))).thenCompose(Function.identity());
    }

    private static void assertSchemaVersionIncreased(@Nullable Integer previousSchemaVersion, Integer schemaVersion) {
        assert (previousSchemaVersion == null || !Objects.equals(schemaVersion, previousSchemaVersion)) : "Same schema version (" + schemaVersion + ") on a retry: something is wrong, is this caused by the test setup?";
    }

    protected static String[] columnNames(List<Column> columns) {
        String[] columnNames = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            columnNames[i] = columns.get(i).name();
        }
        return columnNames;
    }

    @Nullable
    protected Function<SqlRow, R> queryMapper(ResultSetMetadata meta, SchemaDescriptor schema) {
        return null;
    }

    @Override
    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, CriteriaQueryOptions opts) {
        return new CursorAdapter<R>(ViewUtils.sync(this.queryAsync(tx, criteria, indexName, opts)));
    }

    @Override
    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        CriteriaQueryOptions opts0 = opts == null ? CriteriaQueryOptions.DEFAULT : opts;
        CompletableFuture future = this.doOperation(tx, schemaVersion -> {
            SchemaDescriptor schema = this.rowConverter.registry().schema(schemaVersion);
            SqlSerializer ser = new SqlSerializer.Builder().tableName(this.tbl.name()).columns(schema.columns().stream().map(Column::name).collect(Collectors.toList())).indexName(indexName).where(criteria).build();
            Statement statement = this.sql.statementBuilder().query(ser.toString()).pageSize(opts0.pageSize()).build();
            return this.sql.executeAsync(tx, statement, ser.getArguments()).thenApply(resultSet -> {
                ResultSetMetadata meta = resultSet.metadata();
                assert (meta != null) : "Metadata can't be null.";
                return new QueryCriteriaAsyncCursor<R, SqlRow>((AsyncResultSet<SqlRow>)resultSet, this.queryMapper(meta, schema), () -> {});
            });
        });
        return future.exceptionally(th -> {
            throw new CompletionException(CriteriaExceptionMapperUtil.mapToPublicCriteriaException(ExceptionUtils.unwrapCause(th)));
        });
    }

    @FunctionalInterface
    protected static interface KvAction<R> {
        public CompletableFuture<R> act(int var1);
    }
}

