/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;

public interface TombstonesIo {
    public static final int ROW_ID_MSB_OFFSET = 0;
    public static final int ROW_ID_LSB_OFFSET = 8;
    public static final int ROW_TIMESTAMP_OFFSET = 16;
    public static final int SIZE_IN_BYTES = 24;

    public int offset(int var1);

    default public void store(long dstPageAddr, int dstIdx, BplusIo<Tombstone> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory(srcPageAddr, (long)srcOffset, dstPageAddr, (long)dstOffset, 24L);
    }

    default public void storeByOffset(long pageAddr, int off, Tombstone row) {
        RowId rowId = row.rowId();
        PageUtils.putLong(pageAddr, off + 0, rowId.mostSignificantBits());
        PageUtils.putLong(pageAddr, off + 8, rowId.leastSignificantBits());
        HybridTimestamps.writeTimestampToMemory(pageAddr, off + 16, row.timestamp());
    }

    default public int compare(long pageAddr, int idx, Tombstone other) {
        int offset = this.offset(idx);
        RowId otherRowId = other.rowId();
        int cmp = Long.compare(PageUtils.getLong(pageAddr, offset + 0), otherRowId.mostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(PageUtils.getLong(pageAddr, offset + 8), otherRowId.leastSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        HybridTimestamp thisTimestamp = HybridTimestamps.readTimestamp(pageAddr, offset + 16);
        return other.timestamp().compareTo(thisTimestamp);
    }

    default public Tombstone getRow(long pageAddr, int idx, int partitionId) {
        int offset = this.offset(idx);
        long rowIdMsb = PageUtils.getLong(pageAddr, offset + 0);
        long rowIdLsb = PageUtils.getLong(pageAddr, offset + 8);
        return new Tombstone(new RowId(partitionId, rowIdMsb, rowIdLsb), HybridTimestamps.readTimestamp(pageAddr, offset + 16));
    }
}

